<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\App;

class TestTranslations extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:test-translations';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Test translations in all languages';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $languages = ['en', 'ar', 'fr'];
        
        foreach ($languages as $lang) {
            App::setLocale($lang);
            $this->info("Testing language: {$lang}");
            $this->line("App name: " . __('lang.app_name'));
            $this->line("Dashboard: " . __('lang.dashboard'));
            $this->line("Welcome: " . __('auth.welcome'));
            $this->line("Customer name: " . __('customers.name'));
            $this->line("Book appointment: " . __('appointments.book_appointment'));
            $this->line("Save: " . __('forms.save'));
            $this->line("Settings: " . __('settings.title'));
            $this->line("User created: " . __('users.user_created'));
            $this->line("Visit types: " . __('visit_types.title'));
            $this->line("Activity log: " . __('activity_log.activity_log'));
            $this->line("");
        }
        
        $this->info('Translation test completed!');
        return 0;
    }
}
