<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class NewDisplay implements ShouldBroadcast
{
    public int $tenantId;

    public function __construct(int $tenantId)
    {
        $this->tenantId = $tenantId;
    }


    public function broadcastOn()
    {
        // Use public channel so displays can receive updates without authentication
        return new Channel('display.'.$this->tenantId);
    }

    public function broadcastAs()
    {
        return 'DisplayUpdated'; // الاسم الذي ستسمعه في JS
    }

    public function broadcastWith()
    {
        return [
            'message' => 'تم تحديث العرض'
        ];
    }
}
