<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class QueueUpdated implements ShouldBroadcast
{
    use Dispatchable, SerializesModels;

    public int $tenantId;

    public function __construct(int $tenantId)
    {
        $this->tenantId = $tenantId;
    }

    public function broadcastOn()
    {
        // Use public channel so displays can receive updates without authentication
        return new Channel('waiting-room.' . $this->tenantId);
    }

    public function broadcastAs()
    {
        return 'QueueUpdated';
    }

    
}
