<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\WaitingQueue;
use Carbon\Carbon;

class AnalyticsController extends Controller
{
    public function index()
    {
        $totalCustomers = Customer::count();
        $totalAppointments = WaitingQueue::where('type', 'appointment')->count();
        $confirmedAppointments = WaitingQueue::where('type', 'appointment')->where('status', 'completed')->count();
        $cancelledAppointments = WaitingQueue::where('type', 'appointment')->where('status', 'cancelled')->count();

        $appointmentsByDay = WaitingQueue::where('type', 'appointment')->selectRaw('DATE(appointment_time) as day, COUNT(*) as count')
            ->where('appointment_time', '>=', Carbon::now()->subDays(7))
            ->groupBy('day')
            ->orderBy('day')
            ->pluck('count', 'day');

        $appointmentsStatus = WaitingQueue::where('type', 'appointment')->selectRaw('status, COUNT(*) as count')
            ->groupBy('status')
            ->pluck('count', 'status');

        $events = WaitingQueue::where('type', 'appointment')->select('id', 'appointment_time as start', 'customer_id as title')->get();

        return view('analytics.index', compact(
            'totalCustomers',
            'totalAppointments',
            'confirmedAppointments',
            'cancelledAppointments',
            'appointmentsByDay',
            'appointmentsStatus',
            'events'
        ));
    }
}
