<?php

namespace App\Http\Controllers;

use App\Models\WaitingQueue;
use Illuminate\Http\Request;

class CalendarController extends Controller
{
    public function index()
    {
        return view('calendar.index');
    }

    public function events()
    {
        $appointments = WaitingQueue::with('customer')
        ->where('type', 'appointment')
        ->get();

        return response()->json(
            $appointments->map(fn($a) => [
                'id' => $a->id,
                'title' => $a->customer->name ?? 'زبون',
                'start' => $a->appointment_time->toIso8601String(),
            ])
        );

    }

    public function update(Request $request, WaitingQueue $appointment)
    {
        $request->validate([
            'start' => 'required|date',
        ]);

        $appointment->appointment_time = $request->start;
        $appointment->save();

        return response()->json(['success' => true]);
    }
}
