<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\RolePermission;
use App\Models\RoleUser;
use App\Models\Permission;

class CheckPermission
{
    public function handle(Request $request, Closure $next, $permissionKey)
    {
        $user = Auth::user();
        if (!$user) {
            abort(403, 'Unauthorized.');
        }


        if (!$user->is_active) {
            Auth::logout();
            return redirect('/login')->withErrors(['email' => 'حسابك غير مفعل.']);
        }

        // الحصول على أدوار المستخدم
        $roleIds = RoleUser::where('user_id', $user->id)->pluck('id');

        if ($roleIds->isEmpty()) {
            abort(403, 'ليس لديك أي أدوار.');
        }

        // جلب الصلاحية المطلوبة
        $permission = Permission::where('name', $permissionKey)->first();
        if (!$permission) {
            abort(403, 'الصلاحية غير موجودة.');
        }

        // التحقق هل الدور يملك هذه الصلاحية
        $hasPermission = \DB::table('permission_role')->whereIn('role_id', $roleIds)
            ->where('permission_id', $permission->id)
            ->exists();

        if (!$hasPermission) {
            abort(403, 'ليس لديك صلاحية الوصول.');
        }

        return $next($request);
    }
}
