<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SetTenantTimezone
{
    public function handle(Request $request, Closure $next)
    {
        // استخرج المنطقة الزمنية من التينانت أو المستخدم
        $tz = 'UTC';

        // Check for patient routes - patients don't need tenant timezone
        if ($request->is('patient/*')) {
            // Use default timezone for patient routes
            $tz = config('app.timezone', 'UTC');
        } elseif (Auth::check()) {
            // إذا كان للمستخدم Tenant:
            $user = Auth::user();
            if (method_exists($user, 'tenant') && $user->tenant) {
                $tz = $user->tenant->timezone ?: 'UTC';
            } elseif (property_exists($user, 'timezone') && !empty($user->timezone)) {
                // أو لو خزّنتها على المستخدم مباشرة
                $tz = $user->timezone ?: 'UTC';
            }
        }

        // خزّنها في الحاوية لاستخدامها من أي مكان (الـ Cast سيقرأها)
        app()->instance('tenant.tz', $tz);

        // اضبط التوقيت الافتراضي للطلب الحالي (يفيد دوال date() و Carbon::now() في هذا الطلب)
        date_default_timezone_set($tz);
        config(['app.timezone' => $tz]);

        return $next($request);
    }
}
