<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpKernel\Exception\HttpException;

class VerifySignedRoutes
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        $route = $request->route();

        // لو مافيه route (مثلاً assets أو 404) → نسمح بالمتابعة
        if (!$route) {
            return $next($request);
        }

        // نتحقق إذا الرابط عنده parameters (زي user, id, role...)
        if (!empty($route->parameters())) {
            if (!$request->hasValidSignature()) {
                throw new HttpException(500, 'Invalid signature.');
            }
        }

        return $next($request);
    }
}
