<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Scopes\TenantScope;

class Customer extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'phone',
        'email',
        'address',
        'notes',
        'tenant_id',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);

        static::creating(function ($model) {
            if (app()->bound('currentTenant') && empty($model->tenant_id)) {
                $model->tenant_id = app('currentTenant')->id;
            }
        });
    }

    public function waitingQueues()
    {
        return $this->hasMany(WaitingQueue::class);
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class);
    }

    public function currentQueue()
    {
        return $this->hasOne(WaitingQueue::class)->whereIn('status', ['waiting', 'serving']);
    }
}
