<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class DailyStatistic extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'total_customers',
        'served_customers',
        'walk_in_customers',
        'appointment_customers',
        'avg_waiting_time',
    ];

    protected $casts = [
        'date' => 'date',
        'avg_waiting_time' => 'decimal:2',
    ];
}
