<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;


class RoleUser extends Model
{

    protected $table = 'role_user';

    public function permissions()
    {
        return $this->belongsToMany(
            Permission::class,
            'permission_role',
            'role_id', // role_id in permission_role refers to role_user.id
            'permission_id'
        );
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'role_user')->withPivot('tenant_id');
    }
}
