<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Scopes\TenantScope;

class VisitType extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'tenant_id',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);

        static::creating(function ($model) {
            if (app()->bound('currentTenant') && empty($model->tenant_id)) {
                $model->tenant_id = app('currentTenant')->id;
            }
        });
    }

    // علاقة بالمستأجر
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    // علاقة مع waiting queue إذا أحببت
    public function waitingQueues()
    {
        return $this->hasMany(WaitingQueue::class, 'visit_type', 'name');
    }
}
