<?php

namespace App\Services;

use App\Models\User;
use App\Models\SubscriptionPlan;
use App\Models\Permission;

class PlanService
{
    public function assignPlanToUser(User $user, SubscriptionPlan $plan): void
    {
        $user->update([
            'plan_id' => $plan->id,
            'plan_started_at' => now(),
            'plan_expires_at' => now()->addMonth(),
        ]);

        $user->permissions()->delete(); // حذف الصلاحيات القديمة

        foreach ($plan->permissions as $permission) {
            $user->permissions()->create([
                'permission_id' => $permission->id,
            ]);
        }
    }
}
