<?php

return [

    /*
    |--------------------------------------------------------------------------
    | WebSockets Dashboard
    |--------------------------------------------------------------------------
    |
    | Enable/disable the dashboard that shows active connections & stats.
    |
    */
    'dashboard' => [
        'port' => env('WEBSOCKETS_PORT', 6001),
    ],

    /*
    |--------------------------------------------------------------------------
    | WebSockets Apps
    |--------------------------------------------------------------------------
    |
    | Configure the apps that can connect. Values come from .env
    |
    */
    'apps' => [
        [
            'id' => env('PUSHER_APP_ID', 'waitingroom'),
            'name' => env('APP_NAME', 'WaitingRoom'),
            'key' => env('PUSHER_APP_KEY', 'waitingroomkey'),
            'secret' => env('PUSHER_APP_SECRET', 'waitingroomsecret'),
            'path' => env('PUSHER_APP_PATH', ''),
            'capacity' => null,
            'enable_client_messages' => true,
            'enable_statistics' => false,
            'cluster' => env('PUSHER_APP_CLUSTER', 'mt1'),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Broadcasting
    |--------------------------------------------------------------------------
    */
    'allowed_origins' => [
        env('APP_URL', 'http://127.0.0.1'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Performance & Memory Limits
    |--------------------------------------------------------------------------
    |
    | Increase max request size to prevent memory exhaustion when broadcasting
    | bigger payloads. Default is 200 KB; here we set 2 MB.
    |
    */
    'max_request_size_in_kb' => 2000, // 2MB limit per request

    // Limit concurrent HTTP requests per app to prevent overload
    'max_concurrent_requests' => 100,

    // Interval (in seconds) for stats cleanup
'statistics' => [
    'logger' => null,
    'model' => null,
],

    /*
    |--------------------------------------------------------------------------
    | SSL (for HTTPS / WSS)
    |--------------------------------------------------------------------------
    */
    'ssl' => [
        'local_cert' => env('LARAVEL_WEBSOCKETS_SSL_LOCAL_CERT', null),
        'local_pk' => env('LARAVEL_WEBSOCKETS_SSL_LOCAL_PK', null),
        'passphrase' => env('LARAVEL_WEBSOCKETS_SSL_PASSPHRASE', null),
        'verify_peer' => false,
    ],

];
