<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('daily_statistics', function (Blueprint $table) {
            $table->id();
            $table->date('date')->unique();
            $table->integer('total_customers')->default(0);
            $table->integer('appointment_customers')->default(0);
            $table->integer('walk_in_customers')->default(0);
            $table->decimal('average_wait_time', 8, 2)->default(0);
            $table->decimal('total_service_time', 8, 2)->default(0);
            $table->time('peak_hour_start')->nullable();
            $table->time('peak_hour_end')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('daily_statistics');
    }
};
