<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('display_devices', function (Blueprint $table) {
            // Add last_seen_at timestamp for tracking online status
            $table->timestamp('last_seen_at')->nullable()->after('paired_at');
            
            // Add is_authorized column if it doesn't exist
            if (!Schema::hasColumn('display_devices', 'is_authorized')) {
                $table->enum('is_authorized', ['yes', 'non', 'pending'])
                      ->default('non')
                      ->after('last_ip');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('display_devices', function (Blueprint $table) {
            $table->dropColumn(['last_seen_at', 'is_authorized']);
        });
    }
};
