<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('display_devices', function (Blueprint $table) {
            // Add pairing status tracking
            $table->enum('pairing_status', ['waiting', 'in_progress', 'completed'])
                  ->default('waiting')
                  ->after('is_authorized');
            
            // Add pairing session ID for real-time updates
            $table->string('pairing_session_id', 40)->nullable()->after('pairing_status');
            
            // Add pairing started timestamp
            $table->timestamp('pairing_started_at')->nullable()->after('pairing_session_id');
            
            // Add mobile user agent for pairing
            $table->text('pairing_user_agent')->nullable()->after('pairing_started_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('display_devices', function (Blueprint $table) {
            $table->dropColumn([
                'pairing_status',
                'pairing_session_id', 
                'pairing_started_at',
                'pairing_user_agent'
            ]);
        });
    }
};
