<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create default admin user
        User::create([
            'name' => 'المدير العام',
            'email' => 'admin@waitingroom.com',
            'password' => Hash::make('admin123'),
            'role' => 'admin',
            'permissions' => [],
            'is_active' => true,
        ]);

        // Create default assistant user
        User::create([
            'name' => 'مساعد النظام',
            'email' => 'assistant@waitingroom.com',
            'password' => Hash::make('assistant123'),
            'role' => 'assistant',
            'permissions' => [
                'manage_queue',
                'add_customers',
                'view_statistics'
            ],
            'is_active' => true,
        ]);
    }
}
