<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\AppointmentSetting;

class AppointmentSettingSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        AppointmentSetting::create([
            'interval_minutes' => 15,
            'start_time' => '08:00',
            'end_time' => '18:00',
            'working_days' => ['1', '2', '3', '4', '5'], // الاثنين إلى الجمعة
            'max_appointments_per_slot' => 1,
            'allow_same_day_booking' => true,
        ]);
    }
}
