<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run()
    {
        // ✅ حدد tenant_id الذي سيتم استخدامه
        $tenantId = 1;

        // ✅ أولاً، إنشاء الصلاحيات
        $permissions = [
            'view_stats',
            'send_sms',
            'add_customer',
            'edit_customer',
            'delete_customer',
            'manage_users',
        ];

        $permissionIds = [];
        foreach ($permissions as $permName) {
            $permission = Permission::firstOrCreate(['name' => $permName]);
            $permissionIds[$permName] = $permission->id;
        }

        // ✅ ثانياً، إنشاء الأدوار وربط الصلاحيات بها
        $roles = [
            'super_admin' => ['view_stats', 'send_sms', 'add_customer', 'edit_customer', 'delete_customer', 'manage_users'],
            'doctor'      => ['view_stats', 'add_customer'],
            'assistant'   => ['send_sms', 'add_customer'],
        ];

        $roleIds = [];
        foreach ($roles as $roleName => $perms) {
            $role = Role::firstOrCreate([
                'name' => $roleName,
                'tenant_id' => $tenantId
            ]);
            $roleIds[$roleName] = $role->id;

            $role->permissions()->sync(
                collect($perms)->map(fn($p) => $permissionIds[$p])
            );
        }

        // ✅ ثالثاً، إنشاء مستخدم وربطه بدور super_admin
        $user = User::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('password'), // غيّرها لكلمة سر قوية
            ]
        );

        // تأكد من أنه ليس مرتبطًا مسبقًا بنفس الدور والمستأجر
        $user->roles()->syncWithoutDetaching([
            $roleIds['super_admin'] => ['tenant_id' => $tenantId],
        ]);
    }
}
