@extends('layouts.app')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <!-- KPIs -->
        <div class="col-md-3 mb-3">
            <div class="card bg-primary text-white shadow">
                <div class="card-body">{{ __('analytics.customers') }} <h3>{{ $totalCustomers }}</h3></div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-info text-white shadow">
                <div class="card-body">{{ __('analytics.appointments') }} <h3>{{ $totalAppointments }}</h3></div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-success text-white shadow">
                <div class="card-body">{{ __('analytics.confirmed') }} <h3>{{ $confirmedAppointments }}</h3></div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-danger text-white shadow">
                <div class="card-body">{{ __('analytics.cancelled') }} <h3>{{ $cancelledAppointments }}</h3></div>
            </div>
        </div>
    </div>

    <!-- Charts -->
    <div class="row">
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header">{{ __('analytics.appointments_7_days') }}</div>
                <div class="card-body">
                    <div id="chartAppointments"></div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header">{{ __('analytics.appointment_status') }}</div>
                <div class="card-body">
                    <div id="chartStatus"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Calendar -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header">{{ __('analytics.calendar') }}</div>
                <div class="card-body">
                    <div id="calendar"></div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>
<script>
    // Chart: Appointments by Day
    new ApexCharts(document.querySelector("#chartAppointments"), {
        chart: { type: 'line' },
        series: [{ name: '{{ __('analytics.appointments_count') }}', data: @json(array_values($appointmentsByDay->toArray())) }],
        xaxis: { categories: @json(array_keys($appointmentsByDay->toArray())) }
    }).render();

    // Chart: Appointment Status
    new ApexCharts(document.querySelector("#chartStatus"), {
        chart: { type: 'pie' },
        series: @json(array_values($appointmentsStatus->toArray())),
        labels: @json(array_keys($appointmentsStatus->toArray()))
    }).render();

    // FullCalendar
    let calendarEl = document.getElementById('calendar');
    let calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        events: @json($events)
    });
    calendar.render();
</script>
@endpush
