@extends("layouts.app")

@section("content")
<div class="container">
    <div class="row justify-content-center">

        <div class="col-md-6">

            <div class="card mb-4">
                <div class="card-header">{{ __('customers.registered_customers') }}</div>
                <div class="card-body">


                    @if ($customers->count())
                        <table id="customers-table" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>{{ __('customers.name') }}</th>
                                    <th>{{ __('customers.phone') }}</th>
                                    <th>{{ __('customers.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($customers as $customer)
                                    <tr>
                                        <td>{{ $customer->name }}</td>
                                        <td>{{ $customer->phone }}</td>
                                        <td>
                                            <button class="btn btn-sm btn-info load-customer" data-id="{{ $customer->id }}">{{ __('customers.load') }}</button>
                                            <button class="btn btn-sm btn-danger delete-customer" data-id="{{ $customer->id }}">{{ __('customers.delete') }}</button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p class="text-center text-muted">{{ __('customers.no_results') }}</p>
                    @endif

                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">{{ __('appointments.book_appointment') }}</div>

                <div class="card-body">
                    @if (session("success"))
                        <div class="alert alert-success" role="alert">
                            {{ session("success") }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route("appointments.store") }}">
                        @csrf
                        <input type="hidden" id="customer_id" name="customer_id">
                        <div class="row mb-3">
                            <label for="name" class="col-md-4 col-form-label text-md-end">{{ __('appointments.customer_name') }}</label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control @error("name") is-invalid @enderror" name="name" value="{{ old("name") }}" required autocomplete="name" autofocus>

                                @error("name")
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label for="phone" class="col-md-4 col-form-label text-md-end">{{ __('appointments.customer_phone') }} ({{ __('forms.optional_field') }})</label>

                            <div class="col-md-6">
                                <input id="phone" type="text" class="form-control @error("phone") is-invalid @enderror" name="phone" value="{{ old("phone") }}" autocomplete="phone">

                                @error("phone")
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label for="appointment_date" class="col-md-4 col-form-label text-md-end">{{ __('appointments.appointment_date') }}</label>

                            <div class="col-md-6">
                                <input id="appointment_date" type="date" class="form-control @error("appointment_date") is-invalid @enderror" name="appointment_date" value="{{ old("appointment_date", date('Y-m-d')) }}" required min="{{ date('Y-m-d') }}">

                                @error("appointment_date")
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label for="appointment_time" class="col-md-4 col-form-label text-md-end">{{ __('appointments.appointment_time') }}</label>

                            <div class="col-md-6">
                                <select id="appointment_time" class="form-control @error("appointment_time") is-invalid @enderror" name="appointment_time" required>
                                    <option value="">{{ __('appointments.select_time') }}</option>
                                    @foreach($availableSlots as $slot)
                                        <option value="{{ $slot }}" {{ old("appointment_time") == $slot ? "selected" : "" }}>{{ $slot }}</option>
                                    @endforeach
                                </select>

                                @error("appointment_time")
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                                <small class="form-text text-muted">
                                    {{ __('appointments.interval_info', ['minutes' => $settings->interval_minutes]) }}
                                </small>
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('appointments.book_appointment') }}
                                </button>
                                <a href="{{ route("dashboard") }}" class="btn btn-secondary">{{ __('forms.cancel') }}</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const dateInput = document.getElementById("appointment_date");
    const timeSelect = document.getElementById("appointment_time");

    function updateAvailableSlots() {
        const selectedDate = dateInput.value;
        if (!selectedDate) return;

        fetch(`/appointments/available-slots?date=${selectedDate}`)
            .then(response => response.json())
            .then(slots => {
                timeSelect.innerHTML = '<option value="">{{ __('appointments.select_time') }}</option>';
                slots.forEach(slot => {
                    const option = document.createElement('option');
                    option.value = slot;
                    option.textContent = slot;
                    timeSelect.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error fetching available slots:', error);
            });
    }

    dateInput.addEventListener("change", updateAvailableSlots);
});
</script>
@endsection
