@php
    $languages = [
        'ar' => ['name' => 'العربية', 'flag' => 'fi fi-ma', 'color' => '#c1272d'],
        'fr' => ['name' => 'Français', 'flag' => 'fi fi-fr', 'color' => '#0055a4'],
        'en' => ['name' => 'English', 'flag' => 'fi fi-us', 'color' => '#b22234'],
    ];
    $current = app()->getLocale();
@endphp

<div class="dropdown language-switcher">
    <button class="btn btn-outline-light dropdown-toggle d-flex align-items-center gap-2 px-3 py-2"
            type="button"
            id="languageDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
            title="{{ __('forms.select') }} {{ __('settings.language') }}"
            style="border: 1px solid rgba(255,255,255,0.3); border-radius: 8px;">
        <i class="fas fa-globe me-1"></i>
        <span class="d-none d-lg-inline">
            <span class="{{ $languages[$current]['flag'] }} me-1" style="font-size: 1.1em;"></span>
            {{ $languages[$current]['name'] }}
        </span>
        <span class="d-lg-none">
            <span class="{{ $languages[$current]['flag'] }}" style="font-size: 1.1em;"></span>
        </span>
    </button>

    <ul class="dropdown-menu dropdown-menu-end shadow-lg"
        aria-labelledby="languageDropdown"
        style="border-radius: 12px; border: none; min-width: 180px; padding: 8px;">
        <li class="dropdown-header text-muted small fw-bold text-uppercase"
            style="padding: 8px 16px; color: #6c757d !important;">
            <i class="fas fa-language me-1"></i>{{ __('settings.language') }}
        </li>
        @foreach($languages as $code => $language)
            @if($code !== $current)
                <li>
                    <a class="dropdown-item d-flex align-items-center justify-content-between py-2"
                       href="{{ route('change.lang', $code) }}"
                       style="transition: all 0.2s ease; border-radius: 8px;">
                        <div class="d-flex align-items-center gap-2">
                            <span class="{{ $language['flag'] }}" style="font-size: 1.1em;"></span>
                            <span>{{ $language['name'] }}</span>
                        </div>
                        <i class="fas fa-arrow-right text-muted small opacity-0" style="transition: opacity 0.2s ease;"></i>
                    </a>
                </li>
            @else
                <li>
                    <div class="dropdown-item d-flex align-items-center gap-2 py-2 text-primary"
                         style="background: rgba(13, 110, 253, 0.1); border-radius: 8px; cursor: default;">
                        <span class="{{ $language['flag'] }}" style="font-size: 1.1em;"></span>
                        <span class="fw-semibold">{{ $language['name'] }}</span>
                        <span class="badge bg-primary ms-auto small">{{ __('lang.active') }}</span>
                    </div>
                </li>
            @endif
        @endforeach
    </ul>
</div>
