@extends('layouts.app')

@section('title', __('dashboard.title'))

@section('content')
    <div class="row mt-4">
        <!-- Statistics Cards -->
        <div class="col-12 mb-4">
            <div class="row">
                <div class="col-lg-3 col-md-6 mb-3">
                    <div class="stats-card" style="background: linear-gradient(135deg, #28a745, #20c997);">
                        <h3>{{ $todayStats['total_customers'] }}</h3>
                        <p class="mb-0">{{ __('dashboard.total_customers_today') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-3">
                    <div class="stats-card" style="background: linear-gradient(135deg, #007bff, #6610f2);">
                        <h3>{{ $todayStats['completed_customers'] }}</h3>
                        <p class="mb-0">{{ __('dashboard.served_customers') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-3">
                    <div class="stats-card" style="background: linear-gradient(135deg, #ffc107, #fd7e14);">
                        <h3>{{ $todayStats['waiting_customers'] }}</h3>
                        <p class="mb-0">{{ __('dashboard.waiting_customers') }}</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-3">
                    <div class="stats-card" style="background: linear-gradient(135deg, #dc3545, #e83e8c);">
                        <h3>{{ $todayStats['average_wait_time'] }}</h3>
                        <p class="mb-0">{{ __('dashboard.average_wait') }}</p>
                    </div>
                </div>
            </div>
        </div>
        <!--
        <a href="{{ route('queue.queue', $uuid) }}" target="_blank">
            <img src="https://api.qrserver.com/v1/create-qr-code/?data={{ urlencode(route('queue.queue', $uuid)) }}&size=150x150" />
        </a>
    -->
<!-- Currently Serving -->
<div class="col-12 mb-4">

    <div class="current-serving" id="currentServing">


        @if ($currentlyServing)
            <h4><i class="fas fa-user-clock me-2"></i>{{ __('dashboard.currently_serving') }}</h4>
            <h2 class="mb-2">{{ $currentlyServing->customer->name }}</h2>
            <p class="mb-0">
                <i class="fas fa-clock me-2"></i>
                {{ __('dashboard.started_at') }}: {{ $currentlyServing->served_at->format('H:i') }}
            </p>

                    <form action="{{ route('queue.complete', $currentlyServing->id) }}" method="POST" class="mt-3" style="position: relative;float: inline-start;top: -95px;">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-danger next-btn" >
                            <i class="fas fa-stop-circle me-1"></i> {{ __('dashboard.mark_completed') }}
                        </button>
                    </form>
        @else
            <h4><i class="fas fa-user-slash me-2"></i>{{ __('dashboard.no_current') }}</h4>
            <p class="mb-0">{{ __('dashboard.press_next') }}</p>
        @endif
    </div>

</div>

        <!-- Queue Management -->
        <div class="col-lg-8">
            <div class="row">
                <!-- Appointment Queue -->
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-calendar-check me-2"></i>
                                {{ __('dashboard.appointment_clients') }} ({{ $appointmentQueue->count() }})
                            </h5>
                        </div>
                        <div class="card-body" style="max-height: 500px; overflow-y: auto;">
                            @forelse($appointmentQueue as $queue)
                                <div class="queue-item appointment">
                                    <div class="d-flex justify-content-between align-items-start">

                                        <div class="text-end">
                                            @if ($queue->isAppointmentDue())
                                                <span class="badge bg-danger">{{ __('dashboard.due') }}</span>
                                            @else
                                                <span class="badge bg-success">{{ __('dashboard.upcoming') }}</span>
                                            @endif
                                        </div>

                                        <div>
                                            <h6 class="mb-1"style="text-align: center">{{ $queue->customer->name }}</h6>
                                            <small class="text-muted">
                                                <i class="fas fa-clock me-1"></i>
                                                @if ($queue->appointment_time)
                                                    {{ $queue->appointment_time->format('H:i') }}
                                                @endif
                                            </small>
                                            @if ($queue->customer->phone)
                                                |
                                                <small class="text-muted">
                                                    <i class="fas fa-phone me-1"></i>
                                                    {{ $queue->customer->phone }}
                                                </small>
                                            @endif
                                        </div>




                                        <button class="btn btn-sm btn-warning edit-appointment-btn"
                                            data-id="{{ $queue->id }}" data-name="{{ $queue->customer->name }}"
                                            data-type="appointment" data-time="{{ $queue->appointment_time }}"
                                            data-bs-toggle="modal" data-bs-target="#editAppointmentModal">
                                            <i class="fas fa-calendar-alt"></i>
                                        </button>
                                    </div>


                                </div>
                            @empty
                                <div class="text-center text-muted py-4">
                                    <i class="fas fa-calendar-times fa-3x mb-3"></i>
                                    <p>{{ __('dashboard.no_appointments') }}</p>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>

                <!-- Walk-in Queue -->
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-header bg-warning text-dark">
                            <h5 class="mb-0">
                                <i class="fas fa-users me-2"></i>
                                {{ __('dashboard.walkin_clients') }} ({{ $walkInQueue->count() }})
                            </h5>
                        </div>
                        <div class="card-body" style="max-height: 500px; overflow-y: auto;">
                            @forelse($walkInQueue as $index => $queue)
                                <div class="queue-item walk-in">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="text-end">
                                            <span class="badge bg-warning text-dark">{{ $index + 1 }}</span>
                                        </div>
                                        <div>
                                            <h6 class="mb-1 text-center">
                                                {{ $queue->customer->name }}
                                            </h6>

                                            <small class="text-muted">
                                                <i class="fas fa-clock me-1"></i>
                                                {{ __('dashboard.arrived_at') }}: {{ $queue->arrival_time->format('H:i') }}
                                            </small>

                                            @if ($queue->visit_type)
                                            |
                                            <span class="badge bg-info text-dark">
                                                {{ ucfirst($queue->visit_type) }}
                                            </span>
                                        @endif

                                            @if ($queue->customer->phone)
                                                |
                                                <small class="text-muted">
                                                    <i class="fas fa-phone me-1"></i>
                                                    {{ $queue->customer->phone }}
                                                </small>
                                            @endif
                                        </div>


                                        <button class="btn btn-sm btn-primary edit-client-btn"
                                            data-id="{{ $queue->id }}" data-name="{{ $queue->customer->name }}"
                                            data-type="{{ $queue->type }}" data-order="{{ $loop->iteration }}"
                                            data-time="{{ $queue->type === 'walk-in' ? $queue->arrival_time : $queue->appointment_time }}"
                                            data-bs-toggle="modal" data-bs-target="#editClientModal">
                                            <i class="fas fa-edit"></i>
                                        </button>

                                    </div>


                                </div>
                            @empty
                                <div class="text-center text-muted py-4">
                                    <i class="fas fa-user-times fa-3x mb-3"></i>
                                    <p>{{ __('dashboard.no_walkins') }}</p>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Control Panel -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-cogs me-2"></i>
                        {{ __('dashboard.control_panel') }}
                    </h5>
                </div>
                <div class="card-body text-center">
                    <button type="button" class="next-btn mb-4" id="nextCustomerBtn">
                        <i class="fas fa-arrow-left me-2"></i>
                        {{ __('dashboard.next_button') }}
                    </button>

                    <div class="d-grid gap-2">
                        <a href="{{ route('customers.create') }}" class="btn btn-outline-primary">
                            <i class="fas fa-user-plus me-2"></i>
                            {{ __('dashboard.add_customer') }}
                        </a>

                        <a href="{{ route('appointments.create') }}" class="btn btn-outline-info">
                            <i class="fas fa-calendar-plus me-2"></i>
                            {{ __('dashboard.book_appointment') }}
                        </a>

                        <a href="{{ route('statistics.index_stat') }}" class="btn btn-outline-success">
                            <i class="fas fa-chart-bar me-2"></i>
                            {{ __('dashboard.stats') }}
                        </a>

                        @if (auth()->user()->isAdmin())
                            <a href="{{ route('users.index') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-users-cog me-2"></i>
                                {{ __('dashboard.manage_users') }}
                            </a>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="card mt-4">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        {{ __('dashboard.quick_info') }}
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <h4 class="text-success">{{ $appointmentQueue->count() }}</h4>
                            <small class="text-muted">{{ __('dashboard.appointments') }}</small>
                        </div>
                        <div class="col-6">
                            <h4 class="text-warning">{{ $walkInQueue->count() }}</h4>
                            <small class="text-muted">{{ __('dashboard.walkins') }}</small>
                        </div>
                    </div>
                    <hr>
                    <div class="text-center">
                        <small class="text-muted">
                            <i class="fas fa-clock me-1"></i>
                            {{ __('dashboard.last_update') }}: {{ now()->format('H:i:s') }}
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Loading Modal -->
    <div class="modal fade" id="loadingModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center py-4">
                    <div class="spinner-border text-primary mb-3" role="status">
                        <span class="visually-hidden">{{ __('dashboard.loading') }}</span>
                    </div>
                    <p class="mb-0">{{ __('dashboard.loading_message') }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal التعديل -->
    <div class="modal fade" id="editClientModal" tabindex="-1" aria-labelledby="editClientModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <form id="editClientForm" method="POST" action="{{ route('queue.updateOrder') }}">
                @csrf
                @method('POST')
                <input type="hidden" name="id" id="modal-client-id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editClientModalLabel">{{ __('dashboard.edit_client') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('lang.close') }}"></button>
                    </div>
                    <div class="modal-body">
                        <p><strong>{{ __('lang.name') }}:</strong> <span id="modal-client-name"></span></p>
                        <div class="mb-3">
                            <label for="new-order" class="form-label">{{ __('dashboard.new_order') }}</label>
                            <input type="number" class="form-control" name="new_order" id="new-order" min="1"
                                required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">{{ __('dashboard.confirm_edit') }}</button>
                        <button type="button" class="btn btn-danger" id="delete-client-btn">{{ __('lang.delete') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal تعديل موعد -->
    <div class="modal fade" id="editAppointmentModal" tabindex="-1" aria-labelledby="editAppointmentLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <form id="editAppointmentForm" method="POST" action="{{ route('queue.updateAppointment') }}">
                @csrf
                <input type="hidden" name="id" id="appointment-client-id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('dashboard.edit_appointment') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('lang.close') }}"></button>
                    </div>
                    <div class="modal-body">
                        <p><strong>{{ __('lang.name') }}:</strong> <span id="appointment-client-name"></span></p>
                        <div class="mb-3">
                            <label class="form-label">{{ __('dashboard.new_time') }}</label>
                            <input type="datetime-local" class="form-control" name="new_time" id="appointment-new-time"
                                required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">{{ __('dashboard.save_appointment') }}</button>
                        <button type="button" class="btn btn-danger" id="delete-appointment-btn">{{ __('lang.delete') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            // Next Customer Button Click
            $('#nextCustomerBtn').click(function() {

                const btn = $(this);
                const originalText = btn.html();
                const modal = new bootstrap.Modal(document.getElementById('loadingModal'), {
                    backdrop: 'static',
                    keyboard: false
                });
                // Show loading modal
                modal.show();

                // Disable button
                btn.prop('disabled', true);

                $.ajax({
                    url: '{{ route('next.customer') }}',
                    method: 'POST',
                    success: function(response) {

                        if (response.success) {
                            console.log("dddd");
                            // Show success message
                            showAlert('success', response.message);

                            // Reload page after short delay
                            setTimeout(function() {
                                window.location.reload();
                            }, 1500);
                        } else {
                            console.log("ffff");
                            showAlert('warning', response.message);
                            btn.prop('disabled', false);
                        }
                        setTimeout(() => {
                            modal.hide();
                        }, 500);
                    },
                    error: function(xhr) {
                        setTimeout(() => {
                            modal.hide();
                        }, 500);
                        showAlert('danger', '{{ __('dashboard.error_next_customer') }}');
                        btn.prop('disabled', false);
                    }
                });
            });



            function showAlert(type, message) {
                const alertHtml = `
            <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                <i class="fas fa-${type === 'success' ? 'check-circle' : type === 'warning' ? 'exclamation-triangle' : 'exclamation-circle'} me-2"></i>
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;

                $('.container-fluid').prepend(alertHtml);

                // Auto hide after 5 seconds
                setTimeout(function() {
                    $('.alert').fadeOut('slow');
                }, 5000);
            }
        });



        document.querySelectorAll('.edit-client-btn').forEach(button => {
            button.addEventListener('click', function() {
                document.getElementById('modal-client-id').value = this.dataset.id;
                document.getElementById('modal-client-name').textContent = this.dataset.name;
                document.getElementById('new-order').value = this.dataset.order;
            });
        });

        // Appointment modal
        $('.edit-appointment-btn').click(function() {
            $('#appointment-client-id').val($(this).data('id'));
            $('#appointment-client-name').text($(this).data('name'));
            $('#appointment-new-time').val($(this).data('time'));
        });

        // حذف الزبون
        document.getElementById('delete-client-btn').addEventListener('click', function() {
            const id = document.getElementById('modal-client-id').value;
            if (confirm('{{ __('dashboard.confirm_delete_client') }}')) {
                fetch(`{{ url('queue/delete') }}/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json',
                    },
                }).then(response => {
                    if (response.ok) {
                        location.reload();
                    } else {
                        alert('{{ __('dashboard.error_deleting') }}');
                    }
                });
            }
        });

        document.getElementById('delete-appointment-btn').addEventListener('click', function() {
            const id = document.getElementById('appointment-client-id').value;
            if (confirm('{{ __('dashboard.confirm_delete_client') }}')) {
                fetch(`{{ url('queue/delete-appointment') }}/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json',
                    },
                }).then(response => {
                    if (response.ok) {
                        location.reload();
                    } else {
                        alert('{{ __('dashboard.error_deleting') }}');
                    }
                });
            }
        });

        
    </script>
@endpush
