@extends('layouts.app')

@section('title', __('display.confirm_pairing'))

@section('content')
<div class="container py-5" style="max-width: 560px;">
    <h1 class="h3 mb-3">{{ __('display.confirm_pairing') }}</h1>

    <div class="card">
        <div class="card-body">
            <p class="mb-2">{{ __('display.user') }}: <strong>{{ $user->name }}</strong></p>
            <p class="mb-3">{{ __('display.pairing_description') }}</p>

            <form method="POST" action="{{ route('display.pair.store', $device->device_token) }}">
                @csrf
                <div class="mb-3">
                    <label class="form-label">{{ __('display.display_name_optional') }}</label>
                    <input type="text" name="name" class="form-control" placeholder="{{ __('display.name_example') }}">
                </div>
                <button type="submit" class="btn btn-primary w-100">{{ __('display.confirm_pairing_button') }}</button>
            </form>
        </div>
    </div>
</div>
@endsection
