<!DOCTYPE html>
@php $dir = app()->getLocale() === 'ar' ? 'rtl' : 'ltr'; @endphp
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ $dir }}">
<head
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap CSS (RTL for ar, LTR otherwise) -->
    @if(app()->getLocale() === 'ar')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    @else
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    @endif
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Flag Icons -->
    <link href="https://cdn.jsdelivr.net/npm/flag-icons/css/flag-icons.min.css" rel="stylesheet">
    
    <!-- Custom Patient Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="patient-body" dir="{{ $dir }}">
    <div class="d-flex flex-column min-vh-100">
        <!-- Header -->
        <header class="navbar navbar-expand-lg bg-white shadow-sm border-bottom">
            <div class="container">
                <a class="navbar-brand fw-bold text-primary" href="{{ url('/') }}">
                    {{ config('app.name', 'نظام إدارة الانتظار') }}
                </a>
                
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#authNavbar">
                    <span class="navbar-toggler-icon"></span>
                </button>
                
                <div class="collapse navbar-collapse" id="authNavbar">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('patient.login') ? 'active text-primary' : '' }}" 
                               href="{{ route('patient.login') }}">
                                <i class="fas fa-sign-in-alt me-1"></i>
                                {{ __('تسجيل دخول مريض') }}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('patient.register') ? 'active text-primary' : '' }}" 
                               href="{{ route('patient.register') }}">
                                <i class="fas fa-user-plus me-1"></i>
                                {{ __('تسجيل مريض جديد') }}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">
                                <i class="fas fa-users me-1"></i>
                                {{ __('دخول الموظفين') }}
                            </a>
                        </li>
                    </ul>
                </div>

            </div>
        </header>

        <!-- Main Content -->
        <main class="flex-1">
            @yield('content')
        </main>

        <!-- Footer -->
        <footer class="bg-light border-top mt-auto">
            <div class="container py-4">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="text-muted small">
                            {{ __('جميع الحقوق محفوظة') }} &copy; {{ date('Y') }} {{ config('app.name', 'نظام إدارة الانتظار') }}
                        </div>
                    </div>
                    
                    <div class="col-md-6 text-end">
                        <div class="d-flex justify-content-end align-items-center gap-3">
                            <!-- Language Switcher -->
                            <div>
                                <select onchange="changeLanguage(this.value)" class="form-select form-select-sm border-0 bg-transparent text-muted">
                                    <option value="ar" {{ app()->getLocale() == 'ar' ? 'selected' : '' }}>العربية</option>
                                    <option value="en" {{ app()->getLocale() == 'en' ? 'selected' : '' }}>English</option>
                                    <option value="fr" {{ app()->getLocale() == 'fr' ? 'selected' : '' }}>Français</option>
                                </select>
                            </div>
                            
                            <!-- Help Link -->
                            <a href="#" class="text-muted small text-decoration-none">
                                <i class="fas fa-question-circle me-1"></i>
                                {{ __('المساعدة') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Language switcher
        function changeLanguage(lang) {
            window.location.href = `/lang/${lang}`;
        }
        
        // Auto-hide flash messages after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>

    @stack('scripts')
</body>
</html>