<!DOCTYPE html>
@php $dir = app()->getLocale() === 'ar' ? 'rtl' : 'ltr'; @endphp
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ $dir }}">
<head
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{ __('بوابة العملاء') }}</title>

    <!-- Bootstrap CSS (RTL for ar, LTR otherwise) -->
    @if(app()->getLocale() === 'ar')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    @else
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    @endif
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Flag Icons -->
    <link href="https://cdn.jsdelivr.net/npm/flag-icons/css/flag-icons.min.css" rel="stylesheet">
    <!-- Google Fonts Arabic -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- Custom Patient Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="patient-body" dir="{{ $dir }}">
    <!-- Enhanced Navigation -->
    <nav class="navbar navbar-expand-lg patient-nav">
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center w-100">
                <!-- Logo and primary nav -->
                <div class="d-flex align-items-center">
                    <a class="navbar-brand d-flex align-items-center" href="{{ route('patient.dashboard') }}">
                        <div class="me-2">
                            <i class="fas fa-users fa-lg"></i>
                        </div>
                        <span>{{ __('بوابة العملاء') }}</span>
                    </a>

                    <!-- Navigation Links with enhanced styling -->
                    <div class="collapse navbar-collapse ms-4" id="navbarNav">
                        <ul class="navbar-nav me-auto">
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('patient.dashboard') ? 'active' : '' }}"
                                   href="{{ route('patient.dashboard') }}">
                                    <i class="fas fa-home me-2"></i>
                                    <span>{{ __('الرئيسية') }}</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('patient.favorites') ? 'active' : '' }}"
                                   href="{{ route('patient.favorites') }}">
                                    <i class="fas fa-heart me-2"></i>
                                    <span>{{ __('المفضلة') }}</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('patient.history') ? 'active' : '' }}"
                                   href="{{ route('patient.history') }}">
                                    <i class="fas fa-history me-2"></i>
                                    <span>{{ __('customers.service_history') }}</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Enhanced User menu -->
                <div class="d-flex align-items-center">
                    <!-- Quick Action Button -->
                    <a href="{{ route('patient.search') }}" class="btn btn-patient-primary me-3 d-none d-md-inline-flex" title="{{ __('البحث عن الخدمات') }}">
                        <i class="fas fa-search me-2"></i>
                        <span class="d-none d-lg-inline">{{ __('بحث') }}</span>
                    </a>

                    <!-- Mobile menu button -->
                    <button class="navbar-toggler d-lg-none me-3" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                        <i class="fas fa-bars"></i>
                    </button>

                    <!-- Language Switcher -->
                    @include('components.language-switcher')

                    <!-- Enhanced Profile dropdown -->
                    <div class="dropdown">
                        <button class="btn btn-outline-primary dropdown-toggle d-flex align-items-center position-relative"
                                type="button" id="userDropdown" data-bs-toggle="dropdown">
                            <div class="rounded-circle bg-gradient text-white d-flex align-items-center justify-content-center me-2"
                                 style="width: 40px; height: 40px; background: linear-gradient(135deg, #007bff, #28a745);">
                                <i class="fas fa-user"></i>
                            </div>
                                <div class="text-start d-none d-md-block">
                                <div class="fw-bold small">{{ auth('patient')->user()->name ?? '' }}</div>
                                <div class="text-muted" style="font-size: 0.75rem;">{{ __('عميل') }}</div>
                            </div>
                            <!-- Active Queue Indicator -->
                            @if(isset($currentQueues) && $currentQueues->count() > 0)
                            <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" style="font-size: 0.65rem;">
                                {{ $currentQueues->count() }}
                                <span class="visually-hidden">active queues</span>
                            </span>
                            @endif
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end shadow-lg" style="min-width: 250px;">
                            <li class="px-3 py-2 border-bottom">
                                <div class="d-flex align-items-center">
                                    <div class="rounded-circle bg-gradient text-white d-flex align-items-center justify-content-center me-3"
                                         style="width: 48px; height: 48px; background: linear-gradient(135deg, #007bff, #28a745);">
                                        <i class="fas fa-user fa-lg"></i>
                                    </div>
                                    <div>
                                        <div class="fw-bold">{{ auth('patient')->user()->name ?? '' }}</div>
                                        <div class="text-muted small">{{ auth('patient')->user()->email ?? '' }}</div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <a class="dropdown-item py-2" href="{{ route('patient.profile') }}">
                                    <i class="fas fa-user me-3 text-primary"></i>
                                    {{ __('الملف الشخصي') }}
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item py-2" href="{{ route('patient.dashboard') }}">
                                    <i class="fas fa-tachometer-alt me-3 text-info"></i>
                                    {{ __('لوحة التحكم') }}
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <form method="POST" action="{{ route('patient.logout') }}" class="d-inline">
                                    @csrf
                                    <button type="submit" class="dropdown-item text-danger py-2">
                                        <i class="fas fa-sign-out-alt me-3"></i>
                                        {{ __('تسجيل الخروج') }}
                                    </button>
                                </form>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Flash Messages -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Breadcrumb Section -->
    @if(!request()->routeIs('patient.dashboard'))
    <div class="bg-light border-bottom">
        <div class="container-fluid py-2">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{ route('patient.dashboard') }}" class="text-decoration-none">
                            <i class="fas fa-home me-1"></i>
                            {{ __('الرئيسية') }}
                        </a>
                    </li>
                    @if(request()->routeIs('patient.search'))
                    <li class="breadcrumb-item active">{{ __('البحث عن الخدمات') }}</li>
                    @elseif(request()->routeIs('patient.favorites'))
                    <li class="breadcrumb-item active">{{ __('الأماكن المفضلة') }}</li>
                    @elseif(request()->routeIs('patient.history'))
                    <li class="breadcrumb-item active">{{ __('customers.service_history') }}</li>
                    @elseif(request()->routeIs('patient.profile'))
                    <li class="breadcrumb-item active">{{ __('الملف الشخصي') }}</li>
                    @else
                    <li class="breadcrumb-item active">@yield('title')</li>
                    @endif
                </ol>
            </nav>
        </div>
    </div>
    @endif

    <!-- Enhanced Page Content -->
    <main class="flex-grow-1">
        @yield('content')
    </main>

    <!-- Enhanced Footer -->
    <footer class="bg-white border-top mt-auto">
        <div class="container py-5">
            <div class="row g-4">
                <div class="col-md-6">
                    <div class="d-flex align-items-center mb-3">
                        <div class="me-3">
                            <i class="fas fa-building fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h5 class="fw-bold mb-1">{{ __('بوابة العملاء') }}</h5>
                            <p class="text-muted small mb-0">{{ __('نظام إدارة الانتظار الذكي') }}</p>
                        </div>
                    </div>
                    <p class="text-muted small">
                        {{ __('منصة شاملة لإدارة طوابير الانتظار في مختلف الأماكن والمنشآت') }}
                    </p>
                </div>
                <div class="col-md-6">
                    <div class="row g-3">
                        <div class="col-6">
                            <h6 class="fw-bold text-dark mb-3">{{ __('روابط سريعة') }}</h6>
                            <ul class="list-unstyled">
                                <li class="mb-2">
                                    <a href="{{ route('patient.favorites') }}" class="text-decoration-none text-muted hover-text-primary">
                                        <i class="fas fa-heart me-2"></i>
                                        {{ __('المفضلة') }}
                                    </a>
                                </li>
                                <li class="mb-2">
                                    <a href="{{ route('patient.history') }}" class="text-decoration-none text-muted hover-text-primary">
                                        <i class="fas fa-history me-2"></i>
                                        {{ __('السجل') }}
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <h6 class="fw-bold text-dark mb-3">{{ __('الحساب') }}</h6>
                            <ul class="list-unstyled">
                                <li class="mb-2">
                                    <a href="{{ route('patient.profile') }}" class="text-decoration-none text-muted hover-text-primary">
                                        <i class="fas fa-user me-2"></i>
                                        {{ __('الملف') }}
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <hr class="my-4">
            <div class="d-md-flex justify-content-between align-items-center text-center">
                <p class="text-muted small mb-2 mb-md-0">
                    {{ __('جميع الحقوق محفوظة') }} &copy; {{ date('Y') }} {{ __('نظام إدارة الانتظار') }}
                </p>
                <div class="d-flex justify-content-center gap-3">
                    <span class="badge bg-success-subtle text-success">
                        <i class="fas fa-shield-alt me-1"></i>
                        {{ __('آمن') }}
                    </span>
                    <span class="badge bg-primary-subtle text-primary">
                        <i class="fas fa-mobile-alt me-1"></i>
                        {{ __('متجاوب') }}
                    </span>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Auto-hide flash messages after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>

    @stack('scripts')
</body>
</html>
