<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ __('تجربة واجهة العملاء') }}</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        body {
            font-family: 'Cairo', sans-serif;
        }
    </style>
</head>
<body class="bg-light" dir="rtl">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-11">
                <!-- Header -->
                <div class="text-center mb-5">
                    <h1 class="display-4 fw-bold text-dark mb-4">
                        {{ __('واجهة العملاء - نظام إدارة الانتظار') }}
                    </h1>
                    <p class="fs-5 text-muted">
                        {{ __('تجربة تفاعلية لواجهة العملاء الجديدة') }}
                    </p>
                </div>

                <!-- Features Grid -->
                <div class="row g-4 mb-5">
                    
                    <!-- Quick Join -->
                    <div class="col-md-6">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-4">
                                    <div class="flex-shrink-0">
                                        <div class="d-flex align-items-center justify-content-center rounded-3 bg-primary bg-opacity-10" style="width: 48px; height: 48px;">
                                            <svg class="text-primary" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="me-4">
                                        <h3 class="fs-5 fw-semibold text-dark mb-1">{{ __('الانضمام السريع') }}</h3>
                                        <p class="small text-muted mb-0">{{ __('للعملاء الجدد - انضمام فوري للطابور') }}</p>
                                    </div>
                                </div>
                                <p class="text-dark mb-4">
                                    {{ __('يمكن للعملاء الجدد الانضمام للطابور بسرعة باستخدام الاسم ورقم الهاتف فقط دون الحاجة لإنشاء حساب كامل.') }}
                                </p>
                                <a href="{{ url('/create-demo-patient-flow') }}" class="btn btn-primary d-inline-flex align-items-center">
                                    {{ __('جرب الانضمام السريع') }}
                                    <svg class="ms-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-2M7 13l3 3 7-7"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Patient Registration -->
                    <div class="col-md-6">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-4">
                                    <div class="flex-shrink-0">
                                        <div class="d-flex align-items-center justify-content-center rounded-3 bg-success bg-opacity-10" style="width: 48px; height: 48px;">
                                            <svg class="text-success" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="me-4">
                                        <h3 class="fs-5 fw-semibold text-dark mb-1">{{ __('تسجيل عميل جديد') }}</h3>
                                        <p class="small text-muted mb-0">{{ __('إنشاء حساب كامل للعميل') }}</p>
                                    </div>
                                </div>
                                <p class="text-dark mb-4">
                                    {{ __('إنشاء حساب كامل يتيح للعميل تتبع تاريخ الزيارات، إدارة الأماكن المفضلة، والحصول على تحديثات فورية.') }}
                                </p>
                                <a href="{{ route('patient.register') }}" class="btn btn-success d-inline-flex align-items-center">
                                    {{ __('تسجيل عميل جديد') }}
                                    <svg class="ms-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row g-4 mb-5">
                    
                    <!-- Patient Login -->
                    <div class="col-md-6">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-4">
                                    <div class="flex-shrink-0">
                                        <div class="d-flex align-items-center justify-content-center rounded-3" style="width: 48px; height: 48px; background-color: rgba(102, 16, 242, 0.1);">
                                            <svg class="" style="color: #6610f2;" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="me-4">
                                        <h3 class="fs-5 fw-semibold text-dark mb-1">{{ __('تسجيل دخول العميل') }}</h3>
                                        <p class="small text-muted mb-0">{{ __('للعملاء المسجلين مسبقاً') }}</p>
                                    </div>
                                </div>
                                <p class="text-dark mb-4">
                                    {{ __('دخول العملاء المسجلين باستخدام الإيميل وكلمة المرور أو رقم الهاتف ورمز التحقق.') }}
                                </p>
                                <a href="{{ route('patient.login') }}" class="btn d-inline-flex align-items-center" style="background-color: #6610f2; color: white;">
                                    {{ __('تسجيل دخول العميل') }}
                                    <svg class="ms-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Features Overview -->
                    <div class="col-md-6">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-4">
                                    <div class="flex-shrink-0">
                                        <div class="d-flex align-items-center justify-content-center rounded-3 bg-warning bg-opacity-10" style="width: 48px; height: 48px;">
                                            <svg class="text-warning" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="me-4">
                                        <h3 class="fs-5 fw-semibold text-dark mb-1">{{ __('مميزات النظام') }}</h3>
                                        <p class="small text-muted mb-0">{{ __('اكتشف إمكانيات واجهة المرضى') }}</p>
                                    </div>
                                </div>
                                <ul class="list-unstyled text-dark">
                                    <li class="d-flex align-items-center mb-2">
                                        <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        {{ __('تتبع الموقع في الطابور') }}
                                    </li>
                                    <li class="d-flex align-items-center mb-2">
                                        <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        {{ __('تحديثات فورية للحالة') }}
                                    </li>
                                    <li class="d-flex align-items-center mb-2">
                                        <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        {{ __('إدارة العيادات المفضلة') }}
                                    </li>
                                    <li class="d-flex align-items-center mb-0">
                                        <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        {{ __('سجل الزيارات السابقة') }}
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Instructions -->
                <div class="alert alert-primary mb-4">
                    <h2 class="fs-5 fw-semibold mb-3">{{ __('كيفية التجربة:') }}</h2>
                    <ol class="mb-0">
                        <li class="d-flex align-items-start mb-2">
                            <span class="flex-shrink-0 bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3 fw-bold" style="width: 24px; height: 24px; font-size: 0.875rem;">1</span>
                            {{ __('اضغط على "جرب الانضمام السريع" لتجربة الانضمام للطابور كمريض جديد') }}
                        </li>
                        <li class="d-flex align-items-start mb-2">
                            <span class="flex-shrink-0 bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3 fw-bold" style="width: 24px; height: 24px; font-size: 0.875rem;">2</span>
                            {{ __('أو اضغط على "تسجيل مريض جديد" لإنشاء حساب كامل') }}
                        </li>
                        <li class="d-flex align-items-start mb-0">
                            <span class="flex-shrink-0 bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3 fw-bold" style="width: 24px; height: 24px; font-size: 0.875rem;">3</span>
                            {{ __('تابع الخطوات لتجربة كامل مميزات النظام') }}
                        </li>
                    </ol>
                </div>

                <!-- Back to Admin -->
                <div class="text-center">
                    <a href="{{ route('dashboard') }}" class="btn btn-secondary btn-lg d-inline-flex align-items-center">
                        <svg class="me-2" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                        {{ __('العودة للوحة التحكم الإدارية') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
