<!DOCTYPE html>
@php $dir = app()->getLocale() === 'ar' ? 'rtl' : 'ltr'; @endphp
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ $dir }}">
<head
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ __('الانضمام السريع للطابور') }} - {{ $tenant->name }}</title>
    
    <!-- Bootstrap CSS (RTL for ar, LTR otherwise) -->
    @if(app()->getLocale() === 'ar')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    @else
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    @endif
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    @vite(['resources/css/app.css'])
    
    <style>
        body {
            font-family: 'Cairo', sans-serif;
        }
    </style>
</head>
<body class="patient-body bg-light" dir="{{ $dir }}">
    <div class="min-vh-100 d-flex align-items-center py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6 col-lg-5">
                    <!-- Header -->
                    <div class="text-center mb-4">
                        <div class="mx-auto bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                            <i class="fas fa-users fa-2x text-primary"></i>
                        </div>
                        <h1 class="h3 fw-bold text-dark mb-2">
                            {{ __('انضم للطابور') }}
                        </h1>
                        <h2 class="h5 fw-semibold text-primary mb-1">
                            {{ $tenant->name }}
                        </h2>
                        <p class="text-muted small mb-0">
                            <i class="fas fa-map-marker-alt me-1"></i>
                            {{ $tenant->address }}
                        </p>
                    </div>

                    <!-- Quick Join Form Card -->
                    <div class="patient-card">
                        <div class="card-body p-4">
                            

                            <form id="quickJoinForm">
                                @csrf
                                <input type="hidden" name="tenant_uuid" value="{{ $tenant->uuid }}">
                                
                                <!-- Name -->
                                <div class="mb-3">
                                    <label for="name" class="form-label fw-medium text-dark">
                                        <i class="fas fa-user text-primary me-1"></i>
                                        {{ __('الاسم') }} <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="name" id="name" required
                                           class="patient-form-control"
                                           placeholder="{{ __('أدخل اسمك الكامل') }}">
                                </div>

                                <!-- Phone -->
                                <div class="mb-4">
                                    <label for="phone" class="form-label fw-medium text-dark">
                                        <i class="fas fa-phone text-primary me-1"></i>
                                        {{ __('رقم الهاتف') }} <span class="text-danger">*</span>
                                    </label>
                                    <input type="tel" name="phone" id="phone" required
                                           class="patient-form-control" dir="ltr"
                                           placeholder="+966501234567">
                                    <div class="form-text">{{ __('لإرسال تحديثات حالة الطابور') }}</div>
                                </div>


                                <div class="d-grid mb-4">
                                    <button type="submit" id="joinBtn" class="btn btn-patient-primary btn-lg">
                                        <i class="fas fa-paper-plane me-2"></i>
                                        {{ __('إرسال طلب انتظار') }}
                                    </button>
                                </div>
                            </form>

                            <!-- Info -->
                            <div class="alert alert-info border-info" role="alert">
                                <div class="d-flex">
                                    <i class="fas fa-info-circle text-info me-2 mt-1"></i>
                                    <div>
                                        <h6 class="alert-heading fw-medium mb-1">{{ __('كيف يعمل النظام') }}</h6>
                                        <p class="mb-0 small">
                                            {{ __('سيتم إرسال طلبك إلى المكان وسيقوم المسؤول بمراجعة طلبك والموافقة عليه. بعد الموافقة، سيتم إضافتك لقائمة الانتظار.') }}
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Register Link -->
                            <div class="text-center">
                                <hr class="my-4">
                                <a href="{{ route('patient.register') }}" class="btn btn-outline-primary">
                                    <i class="fas fa-user-plus me-1"></i>
                                    {{ __('أو أنشئ حساباً كاملاً') }}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
    document.getElementById('quickJoinForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const joinBtn = document.getElementById('joinBtn');
        const originalHTML = joinBtn.innerHTML;
        
        // Get form data
        const formData = {
            name: document.getElementById('name').value,
            phone: document.getElementById('phone').value,
            tenant_uuid: '{{ $tenant->uuid }}'
        };
        
        
        // Validate
        if (!formData.name.trim() || !formData.phone.trim()) {
            alert('{{ __("يرجى ملء جميع الحقول المطلوبة") }}');
            return;
        }
        
        // Disable button and show loading
        joinBtn.disabled = true;
        joinBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>{{ __("جاري إرسال الطلب...") }}';
        
        // Submit
        fetch('{{ route("patient.quick.join") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify(formData)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Success - show success state
                joinBtn.innerHTML = '<i class="fas fa-check me-2"></i>{{ __("تم إرسال الطلب بنجاح!") }}';
                joinBtn.classList.remove('btn-patient-primary');
                joinBtn.classList.add('btn-success');
                
                // Redirect after showing success
                setTimeout(() => {
                    window.location.href = data.redirect_url || '{{ route("patient.dashboard") }}';
                }, 1500);
            } else {
                // Error
                alert(data.message || '{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
                joinBtn.disabled = false;
                joinBtn.innerHTML = originalHTML;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
            joinBtn.disabled = false;
            joinBtn.innerHTML = originalHTML;
        });
    });
    </script>
</body>
</html>