@extends('layouts.patient')

@section('title', __('البحث عن الخدمات'))

@section('content')
<div class="min-vh-100 bg-light">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="container py-4">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <a href="{{ route('patient.dashboard') }}" class="text-muted me-3 text-decoration-none">
                        <svg width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                    </a>
                    <div>
                        <h1 class="fs-3 fw-bold text-dark mb-1">{{ __('البحث عن الخدمات') }}</h1>
                        <p class="small text-muted mb-0">{{ __('ابحث عن الخدمات والأماكن القريبة منك') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <!-- Search Form -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" action="{{ route('patient.search') }}" class="row g-3">
                    <div class="col-md-6">
                        <label for="q" class="form-label fw-medium">{{ __('البحث') }}</label>
                        <input type="text" class="form-control" id="q" name="q" 
                               value="{{ request('q') }}" 
                               placeholder="{{ __('اسم المكان أو الخدمة...') }}">
                    </div>
                    <div class="col-md-4">
                        <label for="location" class="form-label fw-medium">{{ __('المنطقة') }}</label>
                        <input type="text" class="form-control" id="location" name="location" 
                               value="{{ request('location') }}" 
                               placeholder="{{ __('المدينة أو الحي...') }}">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary w-100 d-flex align-items-center justify-content-center">
                            <svg class="me-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                            {{ __('بحث') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Search Results -->
        @if(request('q') || request('location'))
        <div class="mb-4">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h3 class="fs-5 fw-semibold mb-0">{{ __('نتائج البحث') }}</h3>
                <span class="text-muted">{{ $tenants->total() }} {{ __('نتيجة') }}</span>
            </div>
            
            @if($tenants->count() > 0)
                <div class="row g-4">
                    @foreach($tenants as $tenant)
                    <div class="col-md-6 col-lg-4">
                        <div class="card h-100">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <svg class="text-primary" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                        </svg>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="fs-6 fw-semibold mb-1">{{ $tenant->name }}</h5>
                                        <p class="text-muted small mb-0">
                                            <svg class="me-1" width="12" height="12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            </svg>
                                            {{ $tenant->address ?: __('العنوان غير محدد') }}
                                        </p>
                                    </div>
                                </div>
                                
                                @if($tenant->visitTypes->count() > 0)
                                <div class="mb-3">
                                    <small class="text-muted">{{ __('الخدمات المتاحة:') }}</small>
                                    <div class="mt-1">
                                        @foreach($tenant->visitTypes->take(3) as $visitType)
                                        <span class="badge bg-light text-dark me-1">{{ $visitType->name }}</span>
                                        @endforeach
                                        @if($tenant->visitTypes->count() > 3)
                                        <span class="badge bg-secondary">+{{ $tenant->visitTypes->count() - 3 }}</span>
                                        @endif
                                    </div>
                                </div>
                                @endif
                                
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="text-center">
                                        <div class="fw-bold text-success">{{ __('متاح') }}</div>
                                        <small class="text-muted">{{ __('الحالة') }}</small>
                                    </div>
                                    <a href="{{ route('patient.clinic.show', $tenant->uuid) }}" class="btn btn-primary btn-sm">
                                        {{ __('عرض التفاصيل') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                
                <!-- Pagination -->
                @if($tenants->hasPages())
                <div class="mt-4">
                    {{ $tenants->links() }}
                </div>
                @endif
            @else
                <div class="text-center py-5">
                    <svg class="text-muted mb-3" width="64" height="64" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    <h3 class="fs-5 fw-semibold text-muted">{{ __('لا توجد نتائج') }}</h3>
                    <p class="text-muted">{{ __('لم نجد أي مكان يطابق معايير البحث') }}</p>
                </div>
            @endif
        </div>
        @endif

        <!-- All Available Places -->
        @if(!request('q') && !request('location'))
        <div class="card">
            <div class="card-header">
                <h3 class="fs-5 fw-semibold mb-0">{{ __('جميع الأماكن المتاحة') }}</h3>
            </div>
            <div class="card-body">
                @if($tenants->count() > 0)
                    <div class="row g-4">
                        @foreach($tenants as $tenant)
                        <div class="col-md-6 col-lg-4">
                            <div class="card h-100 border">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                            <svg class="text-primary" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                            </svg>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h5 class="fs-6 fw-semibold mb-1">{{ $tenant->name }}</h5>
                                            <p class="text-muted small mb-0">
                                                <svg class="me-1" width="12" height="12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                </svg>
                                                {{ $tenant->address ?: __('العنوان غير محدد') }}
                                            </p>
                                        </div>
                                    </div>
                                    
                                    @if($tenant->phone)
                                    <div class="mb-2">
                                        <small class="text-muted d-flex align-items-center">
                                            <svg class="me-1" width="12" height="12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                                            </svg>
                                            {{ $tenant->phone }}
                                        </small>
                                    </div>
                                    @endif
                                    
                                    @if($tenant->visitTypes->count() > 0)
                                    <div class="mb-3">
                                        <small class="text-muted">{{ __('الخدمات:') }}</small>
                                        <div class="mt-1">
                                            @foreach($tenant->visitTypes->take(2) as $visitType)
                                            <span class="badge bg-light text-dark me-1 mb-1">{{ $visitType->name }}</span>
                                            @endforeach
                                            @if($tenant->visitTypes->count() > 2)
                                            <span class="badge bg-secondary mb-1">+{{ $tenant->visitTypes->count() - 2 }}</span>
                                            @endif
                                        </div>
                                    </div>
                                    @endif
                                    
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div class="text-center">
                                            <div class="fw-bold text-success">{{ __('متاح') }}</div>
                                            <small class="text-muted">{{ __('الحالة') }}</small>
                                        </div>
                                        <a href="{{ route('patient.clinic.show', $tenant->uuid) }}" class="btn btn-primary btn-sm">
                                            {{ __('انضم للطابور') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    
                    <!-- Pagination -->
                    @if($tenants->hasPages())
                    <div class="mt-4">
                        {{ $tenants->appends(request()->query())->links() }}
                    </div>
                    @endif
                @else
                    <div class="text-center py-5">
                        <svg class="text-muted mb-3" width="64" height="64" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                        <h3 class="fs-5 fw-semibold text-muted">{{ __('لا توجد أماكن متاحة') }}</h3>
                        <p class="text-muted">{{ __('لم يتم إضافة أي أماكن بعد') }}</p>
                    </div>
                @endif
            </div>
        </div>
        @endif
    </div>
</div>

@endsection