@extends('layouts.patient')

@section('title', $tenant->name)

@section('content')
<div class="min-vh-100 bg-light">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="container py-4">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <a href="{{ route('patient.dashboard') }}" class="text-muted me-3 text-decoration-none">
                        <svg class="" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                    </a>
                    <div>
                        <h1 class="fs-3 fw-bold text-dark mb-1">{{ $tenant->name }}</h1>
                        <p class="small text-muted mb-0">{{ $tenant->address }}</p>
                    </div>
                </div>

                <button onclick="toggleFavorite()" id="favoriteBtn"
                        class="btn d-flex align-items-center fw-medium
                        {{ $isFavorite ? 'btn-outline-danger' : 'btn-outline-secondary' }}">
                    <svg class="me-2" width="20" height="20" fill="{{ $isFavorite ? 'currentColor' : 'none' }}" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                    </svg>
                    <span id="favoriteText">{{ $isFavorite ? __('إزالة من المفضلة') : __('إضافة للمفضلة') }}</span>
                </button>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <div class="row g-4">
            <!-- Queue Status -->
            <div class="col-lg-8">

@if($currentQueue)
                    <!-- Currently in Queue -->
                    <div class="card border-primary border-2 mb-4" id="queueStatusCard">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between mb-4">
                                <h2 class="fs-4 fw-semibold text-primary mb-0">{{ __('أنت في الطابور') }}</h2>
                                <div class="d-flex align-items-center">
                                    <div class="bg-success rounded-circle me-2" style="width: 12px; height: 12px; animation: pulse 2s infinite;"></div>
                                    <span class="small text-muted">{{ __('نشط') }}</span>
                                </div>
                            </div>

                            <div class="row g-3 mb-4">
                                @if($positionData && $positionData['type'] === 'walk-in')
                                <div class="col-6 col-md-4 text-center">
                                    <div class="display-4 fw-bold text-primary" id="currentPosition">
                                        @if($positionData && isset($positionData['position']))
                                            #{{ $positionData['position'] }}
                                        @else
                                            -
                                        @endif
                                    </div>
                                    <div class="small text-muted">{{ __('ترتيبك بين الزوار') }}</div>
                                </div>
                                <div class="col-6 col-md-4 text-center">
                                    <div class="display-4 fw-bold text-success">
                                        {{ $positionData['total_walkins_waiting'] ?? 0 }}
                                    </div>
                                    <div class="small text-muted">{{ __('إجمالي الزوار') }}</div>
                                </div>
                                @elseif($positionData && $positionData['type'] === 'appointment')
                                <div class="col-12 text-center">
                                    <div class="p-4 bg-info bg-opacity-10 rounded-3">
                                        <div class="display-6 fw-bold text-info mb-2">
                                            {{ $positionData['appointment_time']->format('d/m/Y') }}
                                        </div>
                                        <div class="display-4 fw-bold text-info mb-2">
                                            {{ $positionData['appointment_time']->format('H:i') }}
                                        </div>
                                        <div class="text-muted">
                                            @if($positionData['is_appointment_due'] ?? false)
                                                <span class="badge bg-success">{{ __('حان وقت الموعد') }}</span>
                                            @else
                                                <span class="badge bg-info">{{ __('موعد مجدول') }}</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @endif


                                <div class="col-6 col-md-4 text-center">
                                    <div class="fs-5 fw-semibold text-dark">{{ $currentQueue->arrival_time->format('H:i') }}</div>
                                    <div class="small text-muted">{{ __('وقت الوصول') }}</div>
                                </div>

                                <div class="col-6 col-md-4 text-center">
                                    <div class="fs-5 fw-semibold
                                        @if($currentQueue->status == 'waiting') text-warning
                                        @elseif($currentQueue->status == 'serving') text-success
                                        @else text-muted @endif">
                                        {{ __($currentQueue->status) }}
                                    </div>
                                    <div class="small text-muted">{{ __('الحالة') }}</div>
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <button onclick="leaveQueue()" class="btn btn-danger">
                                    {{ __('إلغاء الدور') }}
                                </button>
                                <button onclick="refreshStatus()" class="btn btn-outline-secondary">
                                    {{ __('تحديث') }}
                                </button>
                            </div>
                        </div>
                    </div>
                @elseif($pendingRequest)
                    <!-- Pending Join Request -->
                    <div class="card border-warning border-2 mb-4">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between mb-4">
                                <h2 class="fs-4 fw-semibold text-warning mb-0">{{ __('طلبك قيد المراجعة') }}</h2>
                                <div class="d-flex align-items-center">
                                    <div class="bg-warning rounded-circle me-2" style="width: 12px; height: 12px; animation: pulse 2s infinite;"></div>
                                    <span class="small text-muted">{{ __('معلق') }}</span>
                                </div>
                            </div>

                            <div class="alert alert-warning">
                                <div class="d-flex">
                                    <svg class="me-2 flex-shrink-0" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.996-.833-2.768 0L3.05 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                                    </svg>
                                    <div>
                                        <p class="mb-2 fw-medium">{{ __('تم إرسال طلبك بنجاح') }}</p>
                                        <p class="mb-0 small text-muted">
                                            {{ __('سيقوم المسؤول بمراجعة طلبك والموافقة عليه. بعد الموافقة، سيتم إضافتك لقائمة الانتظار وسيتم إشعارك.') }}
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <div class="row text-center">
                                <div class="col-6">
                                    <div class="fs-5 fw-semibold text-dark">{{ $pendingRequest->requested_at->format('H:i') }}</div>
                                    <div class="small text-muted">{{ __('وقت الطلب') }}</div>
                                </div>
                                <div class="col-6">
                                    <div class="fs-5 fw-semibold text-warning">{{ __('معلق') }}</div>
                                    <div class="small text-muted">{{ __('حالة الطلب') }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <!-- Join Queue -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h2 class="fs-4 fw-semibold text-dark mb-4">{{ __('إرسال طلب انتظار') }}</h2>

                            <div class="alert alert-info mb-4">
                                <div class="d-flex">
                                    <svg class="me-2 flex-shrink-0" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <div>
                                        <p class="mb-0 small">
                                            {{ __('سيتم إرسال طلبك إلى المكان وسيقوم المسؤول بمراجعة طلبك والموافقة عليه. بعد الموافقة، سيتم إضافتك لقائمة الانتظار.') }}
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <button onclick="joinQueue()" class="btn btn-primary btn-lg w-100">
                                <svg class="me-2" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                                </svg>
                                {{ __('إرسال طلب انتظار') }}
                            </button>
                        </div>
                    </div>
                @endif


                <!-- Real-time Updates -->
                <div class="alert alert-info d-flex align-items-center">
                    <svg class="me-2" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <span class="small">{{ __('سيتم تحديث حالة الطابور تلقائياً كل 30 ثانية') }}</span>
                </div>
            </div>

            <!-- Clinic Information -->
            <div class="col-lg-4">
                <!-- Contact Information -->
                <div class="card mb-4">
                    <div class="card-body">
                        <h3 class="fs-5 fw-semibold text-dark mb-4">{{ __('معلومات التواصل') }}</h3>

                        <div class="vstack gap-3">
                            @if($tenant->phone)
                            <div class="d-flex align-items-center">
                                <svg class="me-3 text-muted" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                                </svg>
                                <span class="small">{{ $tenant->phone }}</span>
                            </div>
                            @endif

                            @if($tenant->email)
                            <div class="d-flex align-items-center">
                                <svg class="me-3 text-muted" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                </svg>
                                <span class="small">{{ $tenant->email }}</span>
                            </div>
                            @endif

                            @if($tenant->address)
                            <div class="d-flex align-items-start">
                                <svg class="me-3 text-muted flex-shrink-0 mt-1" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                <span class="small">{{ $tenant->address }}</span>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
let isFavorite = {{ $isFavorite ? 'true' : 'false' }};
const tenantUuid = '{{ $tenant->uuid }}';
const isInQueue = {{ $currentQueue ? 'true' : 'false' }};

function toggleFavorite() {
    fetch(`/patient/clinic/${tenantUuid}/favorite`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            isFavorite = data.is_favorite;
            updateFavoriteButton();
        } else {
            alert(data.message || '{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
    });
}

function updateFavoriteButton() {
    const favoriteBtn = document.getElementById('favoriteBtn');
    const favoriteText = document.getElementById('favoriteText');
    const heartIcon = favoriteBtn.querySelector('svg');

    if (isFavorite) {
        favoriteBtn.className = 'btn d-flex align-items-center fw-medium btn-outline-danger';
        favoriteText.textContent = '{{ __("إزالة من المفضلة") }}';
        heartIcon.setAttribute('fill', 'currentColor');
    } else {
        favoriteBtn.className = 'btn d-flex align-items-center fw-medium btn-outline-secondary';
        favoriteText.textContent = '{{ __("إضافة للمفضلة") }}';
        heartIcon.setAttribute('fill', 'none');
    }
}

function joinQueue() {
    const joinBtn = document.querySelector('button[onclick="joinQueue()"]');
    const originalHTML = joinBtn.innerHTML;

    // Disable button and show loading
    joinBtn.disabled = true;
    joinBtn.innerHTML = '<div class="spinner-border spinner-border-sm me-2"></div>{{ __("جاري إرسال الطلب...") }}';

    fetch(`/patient/clinic/${tenantUuid}/join`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({})
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Show success state
            joinBtn.innerHTML = '<svg class="me-2" width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>{{ __("تم إرسال الطلب بنجاح!") }}';
            joinBtn.classList.remove('btn-primary');
            joinBtn.classList.add('btn-success');

            // Show info about request status
            setTimeout(() => {
                location.reload(); // Refresh to show current status
            }, 2000);
        } else {
            alert(data.message || '{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
            joinBtn.disabled = false;
            joinBtn.innerHTML = originalHTML;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
        joinBtn.disabled = false;
        joinBtn.innerHTML = originalHTML;
    });
}

function leaveQueue() {
    if (confirm('{{ __("هل أنت متأكد من إلغاء دورك في الطابور؟") }}')) {
        fetch(`/patient/clinic/${tenantUuid}/leave`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload(); // Refresh to show join queue option
            } else {
                alert(data.message || '{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
        });
    }
}

function refreshStatus() {
    if (!isInQueue) return;

    fetch(`/patient/clinic/${tenantUuid}/queue-status`)
        .then(response => response.json())
        .then(data => {
            if (data.in_queue) {
                if (data.type === 'walk-in' && document.getElementById('currentPosition')) {
                    document.getElementById('currentPosition').textContent = '#' + data.position;
                }
                // For appointments, the display is handled differently and doesn't need real-time updates
            } else if (data.has_request && data.request_status === 'pending') {
                // If request is still pending, reload to show updated status
                location.reload();
            }
        })
        .catch(error => {
            console.error('Error refreshing status:', error);
        });
}

// Auto-refresh queue status every 30 seconds
if (isInQueue) {
    setInterval(refreshStatus, 30000);
}
</script>
@endpush
@endsection
