<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Patient Interface Test - Bootstrap</title>
    
    <!-- Bootstrap CSS RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts Arabic -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="patient-body" dir="rtl">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
            
            <!-- Test Header -->
            <div class="text-center mb-5">
                <h1 class="display-4 fw-bold text-dark mb-3">
                    اختبار تصميم واجهة المرضى
                </h1>
                <p class="lead text-muted">
                    فحص عمل Bootstrap والخطوط العربية
                </p>
            </div>

            <!-- Test Cards -->
            <div class="row g-4 mb-5">
                
                <!-- Card 1 -->
                <div class="col-md-6 col-lg-4">
                    <div class="card patient-card h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-circle p-3 me-3">
                                    <i class="fas fa-user-injured text-primary fs-4"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-0">تسجيل المرضى</h5>
                                </div>
                            </div>
                            <p class="card-text text-muted">
                                نظام تسجيل المرضى يعمل بشكل صحيح مع الخطوط العربية
                            </p>
                            <button class="btn btn-patient-primary w-100">
                                <i class="fas fa-check me-2"></i>
                                اختبار الزر
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Card 2 -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">معلومات الطابور</h3>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">ترتيبك:</span>
                            <span class="font-semibold text-blue-600">#3</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">الوقت المتوقع:</span>
                            <span class="text-sm font-medium">15 دقيقة</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">الحالة:</span>
                            <span class="px-2 py-1 text-xs bg-yellow-100 text-yellow-800 rounded-full">
                                في الانتظار
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Card 3 -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">نموذج اختبار</h3>
                    <form class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">
                                الاسم
                            </label>
                            <input type="text" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                   placeholder="أدخل اسمك هنا">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">
                                رقم الهاتف
                            </label>
                            <input type="tel" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                   placeholder="+966501234567" dir="ltr">
                        </div>
                        <button type="submit" 
                                class="w-full bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded-lg font-medium transition-colors">
                            إرسال
                        </button>
                    </form>
                </div>
            </div>

            <!-- Test Buttons -->
            <div class="flex flex-wrap gap-4 justify-center mb-8">
                <button class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-6 rounded-lg font-medium transition-colors">
                    زر أساسي
                </button>
                <button class="bg-gray-100 hover:bg-gray-200 text-gray-700 py-2 px-6 rounded-lg font-medium transition-colors">
                    زر ثانوي
                </button>
                <button class="bg-red-600 hover:bg-red-700 text-white py-2 px-6 rounded-lg font-medium transition-colors">
                    زر حذف
                </button>
                <button class="bg-green-600 hover:bg-green-700 text-white py-2 px-6 rounded-lg font-medium transition-colors">
                    زر نجاح
                </button>
            </div>

            <!-- Status Tests -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 mb-8">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">اختبار حالات الطوابير</h3>
                <div class="flex flex-wrap gap-3">
                    <span class="px-3 py-1 text-sm bg-yellow-100 text-yellow-800 rounded-full">
                        في الانتظار
                    </span>
                    <span class="px-3 py-1 text-sm bg-green-100 text-green-800 rounded-full">
                        يتم الخدمة
                    </span>
                    <span class="px-3 py-1 text-sm bg-blue-100 text-blue-800 rounded-full">
                        مكتمل
                    </span>
                    <span class="px-3 py-1 text-sm bg-red-100 text-red-800 rounded-full">
                        ملغى
                    </span>
                    <span class="px-3 py-1 text-sm bg-gray-100 text-gray-800 rounded-full">
                        غير محدد
                    </span>
                </div>
            </div>

            <!-- Navigation Test -->
            <div class="text-center">
                <div class="space-x-4">
                    <a href="{{ route('patient.demo') }}" 
                       class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-medium">
                        صفحة التجريب
                    </a>
                    <a href="{{ route('patient.login') }}" 
                       class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-lg font-medium">
                        تسجيل الدخول
                    </a>
                    <a href="{{ route('patient.register') }}" 
                       class="inline-flex items-center px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white rounded-lg font-medium">
                        التسجيل
                    </a>
                </div>
            </div>

            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        console.log('Patient interface test page loaded successfully!');
        console.log('Bootstrap classes are now working properly with Arabic support!');
        
        // Test Bootstrap components
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize tooltips if any
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        });
    </script>
</body>
</html>
