@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('permissions.add_new_permission') }}</h3>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @elseif (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <form action="{{ route('permissions.store') }}" method="POST" class="mb-4">
        @csrf
        <div class="row">
            <div class="col-md-6">
                <label>{{ __('permissions.permission_name') }}:</label>
                <input type="text" name="name" class="form-control" placeholder="{{ __('permissions.example_add_customer') }}" required>
            </div>
            <div class="col-md-6">
                <label>{{ __('permissions.group') }}:</label>
                <input type="text" name="group" class="form-control" placeholder="{{ __('permissions.example_groups') }}" required>
            </div>
        </div>
        <button class="btn btn-success mt-3">{{ __('lang.add') }}</button>
    </form>

    <hr>

    <h5>{{ __('permissions.all_permissions') }}</h5>
    <ul>
        @foreach ($permissions as $perm)
            <li>{{ $perm->name }} <small class="text-muted">({{ $perm->group }})</small></li>
        @endforeach
    </ul>
</div>
@endsection
