@extends('layouts.app')

@section('content')
<div class="container">
    <a href="{{ route('permissions.create') }}" class="btn btn-success mb-3">+ {{ __('permissions.add_permission') }}</a>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>{{ __('lang.name') }}</th>
                <th>{{ __('permissions.group') }}</th>
                <th>{{ __('lang.actions') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($permissions as $perm)
                <tr>
                    <td>{{ $perm->name }}</td>
                    <td>{{ $perm->group }}</td>
                    <td>
                        <a href="{{ route('permissions.edit', $perm) }}" class="btn btn-sm btn-primary">{{ __('lang.edit') }}</a>
                        <form action="{{ route('permissions.destroy', $perm) }}" method="POST" style="display:inline;">
                            @csrf @method('DELETE')
                            <button class="btn btn-sm btn-danger" onclick="return confirm('{{ __('permissions.confirm_delete') }}')">{{ __('lang.delete') }}</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
