@extends('layouts.app')

@section('content')
<div class="container">
    <h2>{{ __('plans.manage_plan_permissions') }}</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <ul class="list-group">
        @foreach($plans as $plan)
            <li class="list-group-item d-flex justify-content-between align-items-center">
                {{ $plan->name }}
                <a href="{{ route('plan-permissions.edit', $plan->id) }}" class="btn btn-sm btn-primary">{{ __('plans.edit_permissions') }}</a>
            </li>
        @endforeach
    </ul>
</div>
@endsection
