@extends('layouts.default')

@push('styles')
<style>
    .install-btn {
        position: fixed;
        bottom: 10px;
        left: 50%;
        transform: translateX(-50%);
        background-color: #3498db;
        color: white;
        padding: 12px 18px;
        border-radius: 25px;
        font-size: 16px;
        cursor: pointer;
        box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        display: none;
    }
</style>
@endpush

@section('content')
<div class="container d-flex justify-content-center align-items-center" style="min-height: 80vh;">
    <div class="card p-4 shadow-lg" style="width: 100%; max-width: 500px; position: relative; border-left: 6px solid #007bff;">
        <h4 class="text-center mb-3">🎫 {{ __('queue.your_ticket') }}</h4>

        <div class="text-center mb-3">
            <h5>{{ __('queue.welcome') }}، {{ $entry->customer->name ?? __('queue.customer') }}</h5>
            <p class="text-muted mb-1">{{ __('queue.turn_type') }}:
                <strong class="text-success">
                    {{ $entry->type === 'appointment' ? __('queue.with_appointment') : __('queue.without_appointment') }}
                </strong>
            </p>

            <p class="mb-1">
                @if ($entry->type === 'appointment')
                    ⏰ {{ __('queue.your_appointment') }}: <strong>{{ $entry->appointment_time->format('H:i') }}</strong>
                @else
                    ⏱ {{ __('queue.arrival_time') }}: <strong>{{ $entry->arrival_time->format('H:i') }}</strong>
                @endif
            </p>

            <p>
                {{ __('queue.customers_before_you') }}: <strong class="text-primary">{{ $preceding->count() }}</strong>
            </p>
        </div>

        @if($preceding->count() > 0)
            <hr>
            <h6 class="text-center">{{ __('queue.who_before_you') }}</h6>
            <ul class="list-group">
                @foreach($preceding as $p)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        {{ $p->customer->name ?? __('queue.customer') }}
                        <span class="badge bg-secondary">
                            {{ $p->arrival_time->format('H:i') }}
                        </span>
                    </li>
                @endforeach
            </ul>
        @endif

        <div class="text-center mt-4">
            <a href="{{ route('queue.check.form', $entry->tenant->uuid) }}" class="btn btn-outline-primary">{{ __('lang.back') }}</a>
        </div>
    </div>
</div>
<button id="installButton" class="install-btn">{{ __('queue.install_app') }}</button>
@endsection
@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        console.log('{{ __('queue.ticket_page_loaded') }}');
    });

    let deferredPrompt;
    const installBtn = document.getElementById('installButton');

    window.addEventListener('beforeinstallprompt', (e) => {
        e.preventDefault();
        deferredPrompt = e;
        installBtn.style.display = 'block';

        installBtn.addEventListener('click', () => {
            deferredPrompt.prompt();
            deferredPrompt.userChoice.then(choice => {
                if (choice.outcome === 'accepted') {
                    console.log('App installed');
                }
                deferredPrompt = null;
                installBtn.style.display = 'none';
            });
        });
    });
</script>
@endpush
