@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4">{{ __('roles.create_new_role') }}</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('roles.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label class="form-label">{{ __('roles.role_name') }}</label>
            <input type="text" name="role_name" class="form-control" required>
        </div>

        <h4>{{ __('roles.available_permissions') }}</h4>
        @foreach($permissions as $groupName => $groupPermissions)
            <div class="card mb-3">
                <div class="card-header">
                    <strong>{{ $groupName }}</strong>
                </div>
                <div class="card-body">
                    @foreach($groupPermissions as $permission)
                        <div class="form-check">
                            <input type="checkbox" name="permissions[]" value="{{ $permission->id }}" class="form-check-input" id="perm{{ $permission->id }}">
                            <label class="form-check-label" for="perm{{ $permission->id }}">
                                {{ $permission->name }}
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach

        <button type="submit" class="btn btn-primary">{{ __('lang.save') }}</button>
    </form>
</div>
@endsection
