@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('roles.manage_roles') }}</h3>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @elseif (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <!-- Form لإضافة دور جديد
    <form action="{{ route('roles.store') }}" method="POST" class="mb-4">
        @csrf
        <div class="input-group">
            <input type="text" name="name" class="form-control" placeholder="اسم الدور الجديد" required>
            <button class="btn btn-success">إضافة</button>
        </div>
    </form>
-->
    <!-- جدول عرض وتعديل وحذف الأدوار -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>{{ __('lang.name') }}</th>
                <th>{{ __('lang.edit') }}</th>
                <th>{{ __('lang.delete') }}</th>
                <th>{{ __('roles.edit_permissions') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($roles as $role)
            <tr>
                <form action="{{ route('roles.update', $role->id) }}" method="POST">
                    @csrf @method('PUT')
                    <td>
                        <input type="text" name="name" value="{{ $role->name }}" class="form-control" required>
                    </td>
                    <td>
                        <button class="btn btn-primary btn-sm">{{ __('lang.save') }}</button>
                    </td>
                </form>
                <td>
                    <form action="{{ route('roles.destroy', $role->id) }}" method="POST" onsubmit="return confirm('{{ __('roles.confirm_delete_role') }}')">
                        @csrf @method('DELETE')
                        <button class="btn btn-danger btn-sm">{{ __('lang.delete') }}</button>
                    </form>
                </td>
                <td>
                    <a href="{{ route('roles.permissions.edit', $role->id) }}" class="btn btn-sm btn-info">
                        {{ __('roles.edit_permissions') }}
                    </a>
                </td>

            </tr>
            @endforeach
        </tbody>
    </table>
</div>


@endsection
