@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('settings.appointment_settings') }}</h3>
    <form method="POST" action="">
        @csrf
        <div class="mb-3">
            <label>{{ __('settings.interval_minutes') }}</label>
            <input type="number" name="interval_minutes" class="form-control" value="{{ $settings->interval_minutes ?? 15 }}">
        </div>
        <div class="mb-3">
            <label>{{ __('settings.start_time') }}</label>
            <input type="time" name="start_time" class="form-control" value="{{ $settings->start_time ?? '09:00' }}">
        </div>
        <div class="mb-3">
            <label>{{ __('settings.end_time') }}</label>
            <input type="time" name="end_time" class="form-control" value="{{ $settings->end_time ?? '17:00' }}">
        </div>
        <div class="mb-3">
            <label>{{ __('settings.working_days') }}</label>
            <select name="working_days[]" class="form-control" multiple>
                @foreach([1 => __('days.monday'), 2 => __('days.tuesday'), 3 => __('days.wednesday'), 4 => __('days.thursday'), 5 => __('days.friday'), 6 => __('days.saturday'), 0 => __('days.sunday')] as $num => $day)
                    <option value="{{ $num }}" @selected(in_array($num, $settings->working_days ?? []))>{{ $day }}</option>
                @endforeach
            </select>
        </div>
        <button class="btn btn-primary">{{ __('lang.save') }}</button>
    </form>
</div>
@endsection
