@extends('layouts.app')
@section('content')
<div class="container-fluid">
    <h2 class="mb-4">📅 {{ __('statistics.appointment_statistics') }}</h2>
    <form method="GET" class="card p-3 mb-4 shadow-sm">
        <div class="row">
            <div class="col-md-3">
                <label>{{ __('statistics.from_date') }}</label>
                <input type="date" name="start_date" value="{{ $startDate }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.to_date') }}</label>
                <input type="date" name="end_date" value="{{ $endDate }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.appointment_type') }}</label>
                <select name="type" class="form-control">
                    <option value="">{{ __('statistics.all') }}</option>
                    <option value="normal" {{ $type=='normal'?'selected':'' }}>{{ __('statistics.normal') }}</option>
                    <option value="special" {{ $type=='special'?'selected':'' }}>{{ __('statistics.special') }}</option>
                </select>
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.status') }}</label>
                <select name="status" class="form-control">
                    <option value="">{{ __('statistics.all') }}</option>
                    <option value="running" {{ $status=='running'?'selected':'' }}>{{ __('statistics.running') }}</option>
                    <option value="finished" {{ $status=='finished'?'selected':'' }}>{{ __('statistics.finished') }}</option>
                    <option value="cancelled" {{ $status=='cancelled'?'selected':'' }}>{{ __('statistics.cancelled') }}</option>
                </select>
            </div>
        </div>
        <div class="mt-3 text-end">
            <button class="btn btn-primary">{{ __('statistics.apply_filter') }}</button>
        </div>
    </form>
    <div class="row g-3">
        <div class="col-md-3">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.total') }}</h5>
                <h3 class="text-primary">{{ $total }}</h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.running') }}</h5>
                <h3 class="text-warning">{{ $running }}</h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.finished') }}</h5>
                <h3 class="text-success">{{ $finished }}</h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.cancelled') }}</h5>
                <h3 class="text-danger">{{ $cancelled }}</h3>
            </div>
        </div>
    </div>

    <div class="row g-3">
        <div class="card col-12 mt-4 shadow-sm p-3">
            <h5 class="mb-3">{{ __('statistics.appointments_by_day') }}</h5>
            <canvas id="appointmentsChart"></canvas>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const chartLabels = @json($chartLabels);
    const chartData = @json($chartData);

    new Chart(document.getElementById('appointmentsChart'), {
        type: 'bar',
        data: {
            labels: chartLabels,
            datasets: [{
                label: '{{ __('statistics.number_of_appointments') }}',
                data: chartData,
                backgroundColor: '#2ecc71'
            }]
        },
        options: {
            responsive: true,
            plugins: {
                title: { display: true, text: '{{ __('statistics.appointments_by_day') }}' }
            },
            scales: { y: { beginAtZero: true } }
        }
    });
</script>
@endsection
