@extends('layouts.empty')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-header bg-primary text-white text-center py-4 rounded-top-4">
                    <h3 class="mb-0 fw-bold">{{ __('tenants.register_clinic') }}</h3>
                    <p class="mb-0 small">{{ __('tenants.fill_information') }}</p>
                </div>

                <div class="card-body p-4">

                    <form action="{{ route('tenants.store') }}" method="POST">
                        @csrf

                        <!-- {{ __('tenants.clinic_info') }} -->
                        <h5 class="text-primary mb-3"><i class="bi bi-hospital"></i> {{ __('tenants.clinic_info') }}</h5>
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">{{ __('tenants.clinic_name') }}</label>
                                <input type="text" name="name" class="form-control" placeholder="{{ __('tenants.clinic_name_example') }}" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">{{ __('lang.email') }}</label>
                                <input type="email" name="email" class="form-control" placeholder="example@clinic.com" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">{{ __('customers.phone') }}</label>
                                <input type="text" name="phone" class="form-control" placeholder="+212 600 000 000">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">{{ __('tenants.plan') }}</label>
                                <select name="subscription_plan_id" class="form-select" required>
                                    <option value="">{{ __('tenants.select_plan') }}</option>
                                    @foreach($plans as $plan)
                                        <option value="{{ $plan->id }}">
                                            {{ $plan->name }} - {{ number_format($plan->price, 2) }} DH
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                                <!-- اختيار الـ Timezone -->
    <div class="mb-3" >
        <label for="timezone" class="form-label">{{ __('tenants.timezone') }}</label>
        <div style="display: flex;">
        <select name="timezone" id="timezone" class="form-select" required>
            <option value="">{{ __('tenants.select_timezone') }}</option>
            @foreach(timezone_identifiers_list() as $tz)
                <option value="{{ $tz }}">{{ $tz }}</option>
            @endforeach
        </select>
        <button type="button" class="btn btn-outline-secondary" onclick="detectTimezone()">{{ __('tenants.detect') }}</button>
        </div>
    </div>

                        </div>

                        <hr class="my-4">

                        <!-- {{ __('tenants.admin_info') }} -->
                        <h5 class="text-primary mb-3"><i class="bi bi-person-lock"></i> {{ __('tenants.admin_info') }}</h5>
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">{{ __('tenants.admin_name') }}</label>
                                <input type="text" name="admin_name" class="form-control" placeholder="{{ __('tenants.full_name') }}" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">{{ __('lang.email') }}</label>
                                <input type="email" name="admin_email" class="form-control" placeholder="admin@clinic.com" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">{{ __('auth.password') }}</label>
                                <input type="password" name="admin_password" class="form-control" placeholder="********" required>
                            </div>
                        </div>

                        <div class="d-grid">
                            <button id="submitBtn" type="submit" class="btn btn-primary btn-lg rounded-pill">
                                <span id="btnText"><i class="bi bi-check-circle"></i> {{ __('tenants.confirm_registration') }}</span>
                                <span id="btnSpinner" class="spinner-border spinner-border-sm d-none"></span>
                            </button>
                        </div>
                    </form>
                </div>

                <div class="card-footer text-center text-muted small">
                    &copy; {{ date('Y') }} {{ __('tenants.all_rights_reserved') }}
                </div>
            </div>

        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const form = document.querySelector("form");
        const submitBtn = document.getElementById("submitBtn");
        const btnText = document.getElementById("btnText");
        const btnSpinner = document.getElementById("btnSpinner");

        form.addEventListener("submit", function() {
            submitBtn.disabled = true; // تعطيل الزر
            btnText.textContent = "{{ __('tenants.creating_account') }}"; // {{ __('forms.loading') }}
            btnSpinner.classList.remove("d-none"); // إظهار اللودر
        });
    });

    function detectTimezone() {
        let tz = Intl.DateTimeFormat().resolvedOptions().timeZone;
        document.getElementById("timezone").value = tz;

    }
    detectTimezone();
</script>
@endpush
