<!DOCTYPE html>
<html>
<head>
    <title>Test QR Generation</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        button { padding: 10px 20px; margin: 10px; cursor: pointer; }
        #qr-display { margin: 20px 0; }
        .info { background: #f0f0f0; padding: 10px; border-radius: 5px; margin: 10px 0; }
    </style>
</head>
<body>
    <h1>QR Login Test</h1>
    
    <div class="info">
        <strong>Test Instructions:</strong><br>
        1. Click "Generate QR Code" to create a QR code<br>
        2. Scan the QR code with your mobile device<br>
        3. Enter your login credentials on the mobile device<br>
        4. Check the status updates below
    </div>
    
    <button onclick="generateQR()">Generate QR Code</button>
    <button onclick="checkStatus()">Check Status</button>
    <button onclick="clearDisplay()">Clear</button>
    
    <div id="qr-display"></div>
    <div id="status-display"></div>
    <div id="log"></div>
    
    <script>
        let currentToken = null;
        
        async function generateQR() {
            try {
                const response = await fetch('/qr-login/generate', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({})
                });
                
                const data = await response.json();
                log('QR Generation Response:', data);
                
                if (data.success) {
                    currentToken = data.token;
                    document.getElementById('qr-display').innerHTML = data.qr_code;
                    log(`QR Code generated successfully. Token: ${data.token}`);
                    log(`Expires at: ${data.expires_at}`);
                    
                    // Auto-check status every 3 seconds
                    setInterval(checkStatus, 3000);
                } else {
                    log('Failed to generate QR code');
                }
            } catch (error) {
                log('Error:', error);
            }
        }
        
        async function checkStatus() {
            if (!currentToken) {
                log('No active QR token');
                return;
            }
            
            try {
                const response = await fetch(`/qr-login/${currentToken}/status`);
                const data = await response.json();
                
                document.getElementById('status-display').innerHTML = `
                    <div style="background: #e6f7ff; padding: 10px; border-radius: 5px; margin: 10px 0;">
                        <strong>Status:</strong> ${data.status}<br>
                        <strong>Success:</strong> ${data.success}<br>
                        ${data.user_name ? `<strong>User:</strong> ${data.user_name}<br>` : ''}
                        ${data.scanned_at ? `<strong>Scanned At:</strong> ${data.scanned_at}<br>` : ''}
                    </div>
                `;
                
                log('Status check:', data);
            } catch (error) {
                log('Status check error:', error);
            }
        }
        
        function clearDisplay() {
            document.getElementById('qr-display').innerHTML = '';
            document.getElementById('status-display').innerHTML = '';
            document.getElementById('log').innerHTML = '';
            currentToken = null;
        }
        
        function log(message, data = null) {
            const logDiv = document.getElementById('log');
            const time = new Date().toLocaleTimeString();
            const logEntry = document.createElement('div');
            logEntry.innerHTML = `<strong>[${time}]</strong> ${message} ${data ? JSON.stringify(data, null, 2) : ''}`;
            logEntry.style.margin = '5px 0';
            logEntry.style.padding = '5px';
            logEntry.style.background = '#f9f9f9';
            logEntry.style.borderRadius = '3px';
            logEntry.style.fontSize = '12px';
            logDiv.appendChild(logEntry);
            
            // Auto scroll to bottom
            logDiv.scrollTop = logDiv.scrollHeight;
        }
    </script>
</body>
</html>