@extends('layouts.default')

@section('content')
<div class="container mt-4">
    <h3>{{ __('settings.visit_types') }}</h3>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <a href="{{ route('visit_types.create') }}" class="btn btn-primary mb-3">{{ __('forms.create') }} {{ __('settings.visit_types') }}</a>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>{{ __('lang.name') }}</th>
                <th>{{ __('lang.actions') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($visitTypes as $vt)
                <tr>
                    <td>{{ $vt->id }}</td>
                    <td>{{ $vt->name }}</td>
                    <td>
                        <a href="{{ route('visit_types.edit', $vt->id) }}" class="btn btn-sm btn-warning">{{ __('lang.edit') }}</a>

                        <form action="{{ route('visit_types.destroy', $vt->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('{{ __('forms.confirm_delete') }}')">{{ __('lang.delete') }}</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
