<!DOCTYPE html>
<html>
<head>
    <title>WebSocket Connection Test</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<body>
    <div id="status">Connecting...</div>
    <div id="messages"></div>
    
    <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
    <script>
        const statusEl = document.getElementById('status');
        const messagesEl = document.getElementById('messages');
        
        function addMessage(msg) {
            messagesEl.innerHTML += '<div>' + new Date().toLocaleTimeString() + ': ' + msg + '</div>';
        }
        
        // Direct Pusher connection test
        const pusher = new Pusher('waitingroomkey', {
            wsHost: '127.0.0.1',
            wsPort: 6001,
            forceTLS: false,
            encrypted: false,
            disableStats: true,
            enabledTransports: ['ws'],
            cluster: 'mt1'
        });

        pusher.connection.bind('connecting', () => {
            statusEl.textContent = 'Connecting to WebSocket...';
            addMessage('Connecting to WebSocket...');
        });

        pusher.connection.bind('connected', () => {
            statusEl.textContent = 'Connected to WebSocket!';
            addMessage('Connected to WebSocket! Socket ID: ' + pusher.connection.socket_id);
        });

        pusher.connection.bind('disconnected', () => {
            statusEl.textContent = 'Disconnected from WebSocket';
            addMessage('Disconnected from WebSocket');
        });

        pusher.connection.bind('error', (error) => {
            statusEl.textContent = 'WebSocket Error: ' + JSON.stringify(error);
            addMessage('WebSocket Error: ' + JSON.stringify(error));
        });

        // Test subscribing to a public channel first
        const testChannel = pusher.subscribe('test-channel');
        
        testChannel.bind('pusher:subscription_succeeded', () => {
            addMessage('Successfully subscribed to test channel');
        });

        testChannel.bind('pusher:subscription_error', (error) => {
            addMessage('Failed to subscribe to test channel: ' + JSON.stringify(error));
        });
    </script>
</body>
</html>