<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\TenantController;
use App\Http\Controllers\QueueController;
use App\Http\Controllers\UserRoleController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\PlanPermissionController;
use App\Http\Controllers\RolePermissionController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/lang/{lang}', function ($lang) {
    if (!in_array($lang, ['en', 'fr', 'ar'])) {
        abort(400);
    }
    session()->put('locale', $lang);
    return back();
})->name('change.lang');

// Redirect root to login
Route::get('/', function () {
    return redirect('/login');
});

// Authentication Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Protected Routes
Route::middleware(['auth'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/next-customer', [DashboardController::class, 'getNextCustomer'])->name('next.customer');
// update ord, delete
    Route::post('/queue/update-order', [DashboardController::class, 'updateOrder'])->name('queue.updateOrder');
    Route::delete('/queue/delete/{id}', [DashboardController::class, 'delete']);

    Route::post('/queue/update-appointment', [DashboardController::class, 'updateAppointment'])->name('queue.updateAppointment');

    Route::delete('/queue/delete-appointment/{id}', [DashboardController::class, 'delete_appointment']);


    // User Profile
    Route::get('/profile', [UserController::class, 'profile'])->name('profile');
    Route::put('/profile', [UserController::class, 'updateProfile'])->name('profile.update');

    // Customer Management
    Route::get("/customers/create", [App\Http\Controllers\CustomerController::class, "create"])->middleware('check_permission:add_customer')->name("customers.create");
    Route::post("/customers", [App\Http\Controllers\CustomerController::class, "store"])->middleware('check_permission:add_customer')->name("customers.store");

  //  Route::get('/customers', [App\Http\Controllers\CustomerController::class, 'index'])->name('customers.index');
Route::get('/customers/{id}', [App\Http\Controllers\CustomerController::class, 'show']);
Route::delete('/customers/{id}', [App\Http\Controllers\CustomerController::class, 'destroy'])->name('customers.destroy');

    // Appointment Management
    Route::get("/appointments/create", [App\Http\Controllers\AppointmentController::class, "create"])->name("appointments.create");
    Route::post("/appointments", [App\Http\Controllers\AppointmentController::class, "store"])->name("appointments.store");
    Route::get("/appointments/available-slots", [App\Http\Controllers\AppointmentController::class, "getAvailableSlots"])->name("appointments.available-slots");

    // Statistics
    Route::get("/statistics", [App\Http\Controllers\StatisticsController::class, "index"])->name("statistics.index");


    Route::get('/calendar', [App\Http\Controllers\CalendarController::class, 'index'])->name('calendar.index');
Route::get('/calendar/events', [App\Http\Controllers\CalendarController::class, 'events'])->name('calendar.events');
Route::post('/calendar/update/{appointment}', [App\Http\Controllers\CalendarController::class, 'update'])->name('calendar.update');


    // User Management (Admin Only)
    Route::middleware(['role:admin'])->group(function () {
        Route::resource('users', UserController::class);

       Route::get('/roless', [UserRoleController::class, 'index'])->name('users.roles');
    Route::post('/{user}/roles/update', [UserRoleController::class, 'update'])->name('users.roles.update');

   Route::middleware(['auth'])->prefix('roles')->group(function () {
    Route::get('/', [RoleController::class, 'index'])->name('roles.index');
    Route::post('/', [RoleController::class, 'store'])->name('roles.store');
    Route::put('/{role}', [RoleController::class, 'update'])->name('roles.update');
    Route::delete('/{role}', [RoleController::class, 'destroy'])->name('roles.destroy');
    Route::get('/{role}/permissions', [RoleController::class, 'editPermissions'])->name('roles.permissions.edit');
    Route::post('/{role}/permissions', [RoleController::class, 'updatePermissions'])->name('roles.permissions.update');
});

//////// superadmin
Route::middleware(['auth'])->prefix('permissions')->group(function () {
    Route::get('/', [PermissionController::class, 'index'])->name('permissions.index');
    Route::post('/', [PermissionController::class, 'store'])->name('permissions.store');
});

Route::get('/plan-permissions', [PlanPermissionController::class, 'listPlans'])->name('plan-permissions.index');
Route::get('/plan-permissions/{plan}/edit', [PlanPermissionController::class, 'edit'])->name('plan-permissions.edit');
Route::post('/plan-permissions/{plan}', [PlanPermissionController::class, 'update'])->name('plan-permissions.update');

///////

Route::middleware(['auth'])->group(function () {
    Route::get('/roles/create-with-user', [RolePermissionController::class, 'create'])->name('roles.create_with_user');
    Route::post('/roles/store-with-user', [RolePermissionController::class, 'store'])->name('roles.store_with_user');
});

    });

    Route::get('/queue/{uuid}', [QueueController::class, 'showPublicQueue'])->name('queue.queue');




});



Route::get('/display', [App\Http\Controllers\DisplayController::class, 'index'])->name('display');
Route::get('/display-data', [App\Http\Controllers\DisplayController::class, 'data'])->name('display.data');

Route::get('/register', [TenantController::class, 'create'])->name('tenants.create');
Route::post('/tenants', [TenantController::class, 'store'])->name('tenants.store');


Route::post('/queue/{uuid}/join', [QueueController::class, 'joinQueue'])->name('queue.queue.join');



Route::get('/check/{uuid}', [QueueController::class, 'showForm'])->name('queue.check.form');
Route::post('/check/{uuid}', [QueueController::class, 'check'])->name('queue.check');



