

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0"><?php echo e(__('Join Requests')); ?></h1>
            <p class="text-muted small mb-0"><?php echo e(__('Manage pending patient requests to join the waiting room')); ?></p>
        </div>
        <div>
            <span class="badge bg-warning fs-6" id="pendingCount"><?php echo e($requests->total()); ?></span>
            <span class="text-muted small"><?php echo e(__('Pending Requests')); ?></span>
        </div>
    </div>

    <?php if($requests->count() > 0): ?>
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0"><?php echo e(__('Pending Join Requests')); ?></h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th><?php echo e(__('Patient')); ?></th>
                                <th><?php echo e(__('Contact')); ?></th>
                                <th><?php echo e(__('Location')); ?></th>
                                <th><?php echo e(__('Requested At')); ?></th>
                                <th class="text-center"><?php echo e(__('Actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="request-row-<?php echo e($request->id); ?>">
                                <td>
                                    <div>
                                        <strong><?php echo e($request->patient->name); ?></strong>
                                    </div>
                                    <?php if($request->patient->email): ?>
                                        <small class="text-muted"><?php echo e($request->patient->email); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($request->patient->phone): ?>
                                        <span class="text-muted">
                                            <i class="fas fa-phone fa-sm me-1"></i><?php echo e($request->patient->phone); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-muted"><?php echo e(__('No phone')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div>
                                        <strong><?php echo e($request->tenant->name); ?></strong>
                                    </div>
                                    <?php if($request->tenant->address): ?>
                                        <small class="text-muted"><?php echo e($request->tenant->address); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div><?php echo e($request->requested_at->format('H:i')); ?></div>
                                    <small class="text-muted"><?php echo e($request->requested_at->format('d/m/Y')); ?></small>
                                    <div class="small text-info"><?php echo e($request->requested_at->diffForHumans()); ?></div>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-success btn-sm" 
                                                onclick="approveRequest('<?php echo e($request->id); ?>')" 
                                                id="approve-btn-<?php echo e($request->id); ?>">
                                            <i class="fas fa-check me-1"></i><?php echo e(__('Approve')); ?>

                                        </button>
                                        <button type="button" class="btn btn-danger btn-sm" 
                                                onclick="rejectRequest('<?php echo e($request->id); ?>')" 
                                                id="reject-btn-<?php echo e($request->id); ?>">
                                            <i class="fas fa-times me-1"></i><?php echo e(__('Reject')); ?>

                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <?php if($requests->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($requests->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="card">
            <div class="card-body text-center py-5">
                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                <h5 class="text-muted"><?php echo e(__('No Pending Requests')); ?></h5>
                <p class="text-muted"><?php echo e(__('All join requests have been processed or there are no new requests.')); ?></p>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Approval Modal -->
<div class="modal fade" id="approvalModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="approvalModalTitle"><?php echo e(__('Approve Join Request')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="visitTypeSelect" class="form-label fw-semibold">
                        <i class="fas fa-stethoscope text-primary me-1"></i>
                        <?php echo e(__('Visit Type')); ?>

                    </label>
                    <select class="form-select form-select-lg" id="visitTypeSelect">
                        <option value=""><?php echo e(__('Select visit type (optional)')); ?></option>
                        <!-- Visit types will be populated dynamically -->
                    </select>
                    <div class="form-text"><?php echo e(__('Choose the appropriate visit type for this patient')); ?></div>
                </div>
                <div class="mb-3">
                    <label for="approvalNotes" class="form-label"><?php echo e(__('Notes (Optional)')); ?></label>
                    <textarea class="form-control" id="approvalNotes" rows="3" 
                              placeholder="<?php echo e(__('Add any notes about this approval...')); ?>"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <button type="button" class="btn btn-success" onclick="confirmApproval()"><?php echo e(__('Approve Request')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Rejection Modal -->
<div class="modal fade" id="rejectionModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Reject Join Request')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="rejectionNotes" class="form-label"><?php echo e(__('Reason for Rejection')); ?></label>
                    <textarea class="form-control" id="rejectionNotes" rows="3" 
                              placeholder="<?php echo e(__('Please provide a reason for rejecting this request...')); ?>" required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <button type="button" class="btn btn-danger" onclick="confirmRejection()"><?php echo e(__('Reject Request')); ?></button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let currentRequestId = null;
let currentRequestData = null;

// Store request data for easy access
const requestsData = {
    <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php echo e($request->id); ?>: {
        id: <?php echo e($request->id); ?>,
        tenant_name: '<?php echo e($request->tenant->name); ?>',
        visit_types: [
            <?php $__currentLoopData = $request->tenant->visitTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visitType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            {
                name: '<?php echo e($visitType->name); ?>',
                duration: <?php echo e($visitType->estimated_duration ?? 'null'); ?>

            },
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]
    },
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
};

function approveRequest(requestId) {
    currentRequestId = requestId;
    currentRequestData = requestsData[requestId];
    
    // Clear previous values
    document.getElementById('approvalNotes').value = '';
    document.getElementById('visitTypeSelect').innerHTML = '<option value=""><?php echo e(__('Select visit type (optional)')); ?></option>';
    
    // Update modal title with tenant name
    const modalTitle = document.getElementById('approvalModalTitle');
    if (currentRequestData) {
        modalTitle.textContent = '<?php echo e(__('Approve Join Request')); ?> - ' + currentRequestData.tenant_name;
    }
    
    // Populate visit types for this tenant
    if (currentRequestData && currentRequestData.visit_types) {
        currentRequestData.visit_types.forEach(function(visitType) {
            const option = document.createElement('option');
            option.value = visitType.name;
            option.textContent = visitType.name + (visitType.duration ? ` (${visitType.duration} min)` : '');
            document.getElementById('visitTypeSelect').appendChild(option);
        });
    }
    
    new bootstrap.Modal(document.getElementById('approvalModal')).show();
}

function rejectRequest(requestId) {
    currentRequestId = requestId;
    document.getElementById('rejectionNotes').value = '';
    new bootstrap.Modal(document.getElementById('rejectionModal')).show();
}

function confirmApproval() {
    if (!currentRequestId) return;
    
    const notes = document.getElementById('approvalNotes').value;
    const visitType = document.getElementById('visitTypeSelect').value;
    const approveBtn = document.getElementById(`approve-btn-${currentRequestId}`);
    
    // Disable buttons
    approveBtn.disabled = true;
    approveBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i><?php echo e(__("Processing...")); ?>';
    
    fetch(`/join-requests/${currentRequestId}/approve`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ 
            notes: notes,
            visit_type: visitType 
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Remove the row
            document.getElementById(`request-row-${currentRequestId}`).remove();
            
            // Update pending count
            const countEl = document.getElementById('pendingCount');
            countEl.textContent = parseInt(countEl.textContent) - 1;
            
            // Show success message
            showAlert('success', data.message || '<?php echo e(__("Request approved successfully!")); ?>');
            
            // Close modal
            bootstrap.Modal.getInstance(document.getElementById('approvalModal')).hide();
            
            // Check if no more requests
            checkEmptyState();
        } else {
            showAlert('danger', data.message || '<?php echo e(__("Failed to approve request")); ?>');
            approveBtn.disabled = false;
            approveBtn.innerHTML = '<i class="fas fa-check me-1"></i><?php echo e(__("Approve")); ?>';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showAlert('danger', '<?php echo e(__("An error occurred")); ?>');
        approveBtn.disabled = false;
        approveBtn.innerHTML = '<i class="fas fa-check me-1"></i><?php echo e(__("Approve")); ?>';
    });
}

function confirmRejection() {
    if (!currentRequestId) return;
    
    const notes = document.getElementById('rejectionNotes').value.trim();
    if (!notes) {
        showAlert('warning', '<?php echo e(__("Please provide a reason for rejection")); ?>');
        return;
    }
    
    const rejectBtn = document.getElementById(`reject-btn-${currentRequestId}`);
    
    // Disable buttons
    rejectBtn.disabled = true;
    rejectBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i><?php echo e(__("Processing...")); ?>';
    
    fetch(`/join-requests/${currentRequestId}/reject`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ notes: notes })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Remove the row
            document.getElementById(`request-row-${currentRequestId}`).remove();
            
            // Update pending count
            const countEl = document.getElementById('pendingCount');
            countEl.textContent = parseInt(countEl.textContent) - 1;
            
            // Show success message
            showAlert('success', data.message || '<?php echo e(__("Request rejected successfully!")); ?>');
            
            // Close modal
            bootstrap.Modal.getInstance(document.getElementById('rejectionModal')).hide();
            
            // Check if no more requests
            checkEmptyState();
        } else {
            showAlert('danger', data.message || '<?php echo e(__("Failed to reject request")); ?>');
            rejectBtn.disabled = false;
            rejectBtn.innerHTML = '<i class="fas fa-times me-1"></i><?php echo e(__("Reject")); ?>';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showAlert('danger', '<?php echo e(__("An error occurred")); ?>');
        rejectBtn.disabled = false;
        rejectBtn.innerHTML = '<i class="fas fa-times me-1"></i><?php echo e(__("Reject")); ?>';
    });
}

function showAlert(type, message) {
    const alertDiv = document.createElement('div');
    alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
    alertDiv.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    const container = document.querySelector('.container-fluid');
    container.insertBefore(alertDiv, container.firstChild);
    
    setTimeout(() => {
        alertDiv.remove();
    }, 5000);
}

function checkEmptyState() {
    const tableBody = document.querySelector('tbody');
    if (tableBody && tableBody.children.length === 0) {
        location.reload(); // Reload to show empty state
    }
}

// Auto-refresh pending count every 30 seconds
setInterval(() => {
    fetch('/join-requests/api/pending-count')
        .then(response => response.json())
        .then(data => {
            if (data.pending_count !== undefined) {
                document.getElementById('pendingCount').textContent = data.pending_count;
            }
        })
        .catch(error => console.error('Error updating pending count:', error));
}, 30000);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/staff/join-requests/index.blade.php ENDPATH**/ ?>