

<?php $__env->startSection('title', __('تسجيل عميل جديد')); ?>

<?php $__env->startSection('content'); ?>
<div class="min-vh-100 bg-light d-flex align-items-center py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <!-- Header -->
                <div class="text-center mb-4">
                    <div class="mx-auto bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 64px; height: 64px;">
                        <i class="fas fa-user-plus fa-2x text-primary"></i>
                    </div>
                    <h2 class="h3 fw-bold text-dark mb-2">
                        <?php echo e(__('إنشاء حساب جديد')); ?>

                    </h2>
                    <p class="text-muted small mb-0">
                        <?php echo e(__('أنشئ حسابك لتتبع طوابير الانتظار بسهولة')); ?>

                    </p>
                </div>

                <!-- Register Form Card -->
                <div class="patient-card">
                    <div class="card-body p-4">
                        
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="small mb-1"><i class="fas fa-exclamation-circle me-1"></i><?php echo e($error); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('patient.register')); ?>">
                            <?php echo csrf_field(); ?>

                            <!-- Name -->
                            <div class="mb-3">
                                <label for="name" class="form-label fw-medium text-dark">
                                    <i class="fas fa-user text-primary me-1"></i>
                                    <?php echo e(__('الاسم الكامل')); ?> <span class="text-danger">*</span>
                                </label>
                                <input type="text" name="name" id="name" required
                                       class="patient-form-control"
                                       value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('أدخل اسمك الكامل')); ?>">
                            </div>

                            <!-- Contact Method Selection -->
                            <div class="mb-4">
                                <label class="form-label fw-medium text-dark">
                                    <?php echo e(__('طريقة التواصل المفضلة')); ?> <span class="text-danger">*</span>
                                </label>
                                <div class="btn-group w-100" role="group">
                                    <input type="radio" class="btn-check" name="contact_method_radio" id="emailContactTabRadio" checked>
                                    <label class="btn btn-outline-primary" for="emailContactTabRadio" id="emailContactTab">
                                        <i class="fas fa-envelope me-1"></i>
                                        <?php echo e(__('الإيميل')); ?>

                                    </label>
                                    
                                    <input type="radio" class="btn-check" name="contact_method_radio" id="phoneContactTabRadio">
                                    <label class="btn btn-outline-primary" for="phoneContactTabRadio" id="phoneContactTab">
                                        <i class="fas fa-phone me-1"></i>
                                        <?php echo e(__('الهاتف')); ?>

                                    </label>
                                </div>
                                <input type="hidden" name="contact_method" id="contactMethod" value="email">
                            </div>

                            <!-- Email Contact Form -->
                            <div id="emailContactForm">
                                <div class="mb-3">
                                    <label for="email" class="form-label fw-medium text-dark">
                                        <i class="fas fa-envelope text-primary me-1"></i>
                                        <?php echo e(__('الإيميل')); ?> <span class="text-danger">*</span>
                                    </label>
                                    <input type="email" name="email" id="email"
                                           class="patient-form-control"
                                           value="<?php echo e(old('email')); ?>" dir="ltr" placeholder="example@email.com">
                                </div>

                                <div class="mb-3">
                                    <label for="password" class="form-label fw-medium text-dark">
                                        <i class="fas fa-lock text-primary me-1"></i>
                                        <?php echo e(__('كلمة المرور')); ?> <span class="text-muted small">(<?php echo e(__('اختيارية')); ?>)</span>
                                    </label>
                                    <input type="password" name="password" id="password"
                                           class="patient-form-control"
                                           dir="ltr" placeholder="••••••••">
                                    <div class="form-text"><?php echo e(__('إذا لم تدخل كلمة مرور، يمكنك تسجيل الدخول برمز التحقق عبر الإيميل')); ?></div>
                                </div>

                                <div class="mb-4">
                                    <label for="password_confirmation" class="form-label fw-medium text-dark">
                                        <i class="fas fa-lock text-primary me-1"></i>
                                        <?php echo e(__('تأكيد كلمة المرور')); ?>

                                    </label>
                                    <input type="password" name="password_confirmation" id="password_confirmation"
                                           class="patient-form-control"
                                           dir="ltr" placeholder="••••••••">
                                </div>
                            </div>

                            <!-- Phone Contact Form -->
                            <div id="phoneContactForm" style="display: none;">
                                <div class="mb-4">
                                    <label for="phone" class="form-label fw-medium text-dark">
                                        <i class="fas fa-phone text-primary me-1"></i>
                                        <?php echo e(__('رقم الهاتف')); ?> <span class="text-danger">*</span>
                                    </label>
                                    <input type="tel" name="phone" id="phone"
                                           class="patient-form-control"
                                           value="<?php echo e(old('phone')); ?>" dir="ltr" placeholder="+966501234567">
                                    <div class="form-text"><?php echo e(__('سيتم إرسال رمز تحقق لهذا الرقم لتسجيل الدخول')); ?></div>
                                </div>
                            </div>

                            <!-- Optional Fields -->
                            <div class="mb-3">
                                <label for="date_of_birth" class="form-label fw-medium text-dark">
                                    <i class="fas fa-calendar-alt text-primary me-1"></i>
                                    <?php echo e(__('تاريخ الميلاد')); ?> <span class="text-muted small">(<?php echo e(__('اختياري')); ?>)</span>
                                </label>
                                <input type="date" name="date_of_birth" id="date_of_birth"
                                       class="patient-form-control"
                                       value="<?php echo e(old('date_of_birth')); ?>">
                            </div>

                            <div class="mb-4">
                                <label for="preferred_language" class="form-label fw-medium text-dark">
                                    <i class="fas fa-language text-primary me-1"></i>
                                    <?php echo e(__('اللغة المفضلة')); ?>

                                </label>
                                <select name="preferred_language" id="preferred_language"
                                        class="patient-form-control">
                                    <option value="ar" <?php echo e(old('preferred_language') == 'ar' ? 'selected' : ''); ?>><?php echo e(__('العربية')); ?></option>
                                    <option value="en" <?php echo e(old('preferred_language') == 'en' ? 'selected' : ''); ?>><?php echo e(__('English')); ?></option>
                                    <option value="fr" <?php echo e(old('preferred_language') == 'fr' ? 'selected' : ''); ?>><?php echo e(__('Français')); ?></option>
                                </select>
                            </div>

                            <div class="d-grid mb-4">
                                <button type="submit" class="btn btn-patient-primary">
                                    <i class="fas fa-user-plus me-1"></i>
                                    <?php echo e(__('إنشاء الحساب')); ?>

                                </button>
                            </div>
                        </form>

                        <div class="text-center">
                            <hr class="my-4">
                            <span class="px-3 bg-white text-muted small position-relative" style="top: -12px;"><?php echo e(__('أو')); ?></span>
                        </div>

                        <div class="d-grid">
                            <a href="<?php echo e(route('patient.login')); ?>" 
                               class="btn btn-patient-secondary">
                                <i class="fas fa-sign-in-alt me-1"></i>
                                <?php echo e(__('لديك حساب؟ سجل دخولك')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const emailContactTabRadio = document.getElementById('emailContactTabRadio');
    const phoneContactTabRadio = document.getElementById('phoneContactTabRadio');
    const emailContactForm = document.getElementById('emailContactForm');
    const phoneContactForm = document.getElementById('phoneContactForm');
    const contactMethod = document.getElementById('contactMethod');

    // Set initial state - email enabled, phone disabled
    const emailInput = document.getElementById('email');
    const passwordInput = document.getElementById('password');
    const passwordConfirmInput = document.getElementById('password_confirmation');
    const phoneInput = document.getElementById('phone');
    
    emailInput.disabled = false;
    passwordInput.disabled = false;
    passwordConfirmInput.disabled = false;
    phoneInput.disabled = true;
    
    // Set name attributes for enabled fields only
    emailInput.setAttribute('name', 'email');
    passwordInput.setAttribute('name', 'password');
    passwordConfirmInput.setAttribute('name', 'password_confirmation');
    phoneInput.removeAttribute('name');

    // Tab switching
    emailContactTabRadio.addEventListener('change', function() {
        if (this.checked) {
            emailContactForm.style.display = 'block';
            phoneContactForm.style.display = 'none';
            contactMethod.value = 'email';
            
            // Reset and disable phone form
            const phoneInput = document.getElementById('phone');
            phoneInput.value = '';
            phoneInput.disabled = true;
            phoneInput.required = false;
            phoneInput.removeAttribute('name');
            
            // Enable email fields
            const emailInput = document.getElementById('email');
            const passwordInput = document.getElementById('password');
            const passwordConfirmInput = document.getElementById('password_confirmation');
            
            emailInput.disabled = false;
            passwordInput.disabled = false;
            passwordConfirmInput.disabled = false;
            emailInput.required = true;
            
            emailInput.setAttribute('name', 'email');
            passwordInput.setAttribute('name', 'password');
            passwordConfirmInput.setAttribute('name', 'password_confirmation');
        }
    });

    phoneContactTabRadio.addEventListener('change', function() {
        if (this.checked) {
            phoneContactForm.style.display = 'block';
            emailContactForm.style.display = 'none';
            contactMethod.value = 'phone';
            
            // Reset and disable email form
            const emailInput = document.getElementById('email');
            const passwordInput = document.getElementById('password');
            const passwordConfirmInput = document.getElementById('password_confirmation');
            
            emailInput.value = '';
            passwordInput.value = '';
            passwordConfirmInput.value = '';
            
            emailInput.disabled = true;
            passwordInput.disabled = true;
            passwordConfirmInput.disabled = true;
            emailInput.required = false;
            
            emailInput.removeAttribute('name');
            passwordInput.removeAttribute('name');
            passwordConfirmInput.removeAttribute('name');
            
            // Enable phone field
            const phoneInput = document.getElementById('phone');
            phoneInput.disabled = false;
            phoneInput.required = true;
            phoneInput.setAttribute('name', 'phone');
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/patient/auth/register.blade.php ENDPATH**/ ?>