<?php $__env->startSection('content'); ?>
<div class="container">
    <h3><?php echo e(__('roles.manage_roles')); ?></h3>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php elseif(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <!-- Form لإضافة دور جديد
    <form action="<?php echo e(route('roles.store')); ?>" method="POST" class="mb-4">
        <?php echo csrf_field(); ?>
        <div class="input-group">
            <input type="text" name="name" class="form-control" placeholder="اسم الدور الجديد" required>
            <button class="btn btn-success">إضافة</button>
        </div>
    </form>
-->
    <!-- جدول عرض وتعديل وحذف الأدوار -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th><?php echo e(__('lang.name')); ?></th>
                <th><?php echo e(__('lang.edit')); ?></th>
                <th><?php echo e(__('lang.delete')); ?></th>
                <th><?php echo e(__('roles.edit_permissions')); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <form action="<?php echo e(route('roles.update', $role->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                    <td>
                        <input type="text" name="name" value="<?php echo e($role->name); ?>" class="form-control" required>
                    </td>
                    <td>
                        <button class="btn btn-primary btn-sm"><?php echo e(__('lang.save')); ?></button>
                    </td>
                </form>
                <td>
                    <form action="<?php echo e(route('roles.destroy', $role->id)); ?>" method="POST" onsubmit="return confirm('<?php echo e(__('roles.confirm_delete_role')); ?>')">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-danger btn-sm"><?php echo e(__('lang.delete')); ?></button>
                    </form>
                </td>
                <td>
                    <a href="<?php echo e(route('roles.permissions.edit', $role->id)); ?>" class="btn btn-sm btn-info">
                        <?php echo e(__('roles.edit_permissions')); ?>

                    </a>
                </td>

            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/roles/index.blade.php ENDPATH**/ ?>