

<?php $__env->startSection('title', __('تسجيل دخول المريض')); ?>

<?php $__env->startSection('content'); ?>
<div class="min-vh-100 bg-light d-flex align-items-center py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <!-- Header -->
                <div class="text-center mb-4">
                    <div class="mx-auto bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 64px; height: 64px;">
                        <i class="fas fa-user fa-2x text-primary"></i>
                    </div>
                    <h2 class="h3 fw-bold text-dark mb-2">
                        <?php echo e(__('مرحباً بعودتك')); ?>

                    </h2>
                    <p class="text-muted small mb-0">
                        <?php echo e(__('سجل دخولك لتتبع طوابير الانتظار المفضلة لديك')); ?>

                    </p>
                </div>

                <!-- Login Form Card -->
                <div class="patient-card">
                    <div class="card-body p-4">
                        
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="small mb-1"><i class="fas fa-exclamation-circle me-1"></i><?php echo e($error); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <?php if(session('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-1"></i><?php echo e(session('success')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <!-- Login Method Selection -->
                        <div class="mb-4">
                            <div class="btn-group w-100" role="group">
                                <input type="radio" class="btn-check" name="login_method_radio" id="emailTabRadio" checked>
                                <label class="btn btn-outline-primary" for="emailTabRadio" id="emailTab">
                                    <i class="fas fa-envelope me-1"></i>
                                    <?php echo e(__('الإيميل')); ?>

                                </label>
                                
                                <input type="radio" class="btn-check" name="login_method_radio" id="phoneTabRadio">
                                <label class="btn btn-outline-primary" for="phoneTabRadio" id="phoneTab">
                                    <i class="fas fa-phone me-1"></i>
                                    <?php echo e(__('الهاتف')); ?>

                                </label>
                            </div>
                        </div>

                        <form method="POST" action="<?php echo e(route('patient.login')); ?>" id="loginForm">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="login_method" id="loginMethod" value="email">

                            <!-- Email Login Form -->
                            <div id="emailForm">
                                <div class="mb-3">
                                    <label for="email" class="form-label fw-medium text-dark">
                                        <i class="fas fa-envelope text-primary me-1"></i>
                                        <?php echo e(__('الإيميل')); ?>

                                    </label>
                                    <input type="email" name="email" id="email" 
                                           class="patient-form-control"
                                           value="<?php echo e(old('email')); ?>" dir="ltr" placeholder="example@email.com">
                                </div>

                                <div class="mb-4">
                                    <label for="password" class="form-label fw-medium text-dark">
                                        <i class="fas fa-lock text-primary me-1"></i>
                                        <?php echo e(__('كلمة المرور')); ?>

                                    </label>
                                    <input type="password" name="password" id="password" 
                                           class="patient-form-control"
                                           dir="ltr" placeholder="••••••••">
                                </div>
                            </div>

                            <!-- Phone Login Form -->
                            <div id="phoneForm" style="display: none;">
                                <div class="mb-3">
                                    <label for="phone" class="form-label fw-medium text-dark">
                                        <i class="fas fa-phone text-primary me-1"></i>
                                        <?php echo e(__('رقم الهاتف')); ?>

                                    </label>
                                    <input type="tel" name="phone" id="phone" 
                                           class="patient-form-control"
                                           value="<?php echo e(old('phone')); ?>" dir="ltr" placeholder="+966501234567">
                                    <button type="button" id="sendCodeBtn" 
                                            class="btn btn-patient-secondary w-100 mt-2">
                                        <i class="fas fa-sms me-1"></i>
                                        <?php echo e(__('إرسال رمز التحقق')); ?>

                                    </button>
                                </div>

                                <div class="mb-4" id="verificationCodeDiv" style="display: none;">
                                    <label for="verification_code" class="form-label fw-medium text-dark">
                                        <i class="fas fa-key text-primary me-1"></i>
                                        <?php echo e(__('رمز التحقق')); ?>

                                    </label>
                                    <input type="text" name="verification_code" id="verification_code" 
                                           class="patient-form-control"
                                           dir="ltr" placeholder="1234">
                                    <p class="mt-2 small text-muted" id="codeDisplay"></p>
                                </div>
                            </div>

                            <div class="d-flex align-items-center justify-content-between mb-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="remember" name="remember">
                                    <label class="form-check-label small text-muted" for="remember">
                                        <?php echo e(__('تذكرني')); ?>

                                    </label>
                                </div>
                            </div>

                            <div class="d-grid mb-4">
                                <button type="submit" class="btn btn-patient-primary">
                                    <i class="fas fa-sign-in-alt me-1"></i>
                                    <?php echo e(__('تسجيل الدخول')); ?>

                                </button>
                            </div>
                        </form>

                        <div class="text-center">
                            <hr class="my-4">
                            <span class="px-3 bg-white text-muted small position-relative" style="top: -12px;"><?php echo e(__('أو')); ?></span>
                        </div>

                        <div class="d-grid">
                            <a href="<?php echo e(route('patient.register')); ?>" 
                               class="btn btn-patient-secondary">
                                <i class="fas fa-user-plus me-1"></i>
                                <?php echo e(__('إنشاء حساب جديد')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const emailTabRadio = document.getElementById('emailTabRadio');
    const phoneTabRadio = document.getElementById('phoneTabRadio');
    const emailForm = document.getElementById('emailForm');
    const phoneForm = document.getElementById('phoneForm');
    const loginMethod = document.getElementById('loginMethod');
    const sendCodeBtn = document.getElementById('sendCodeBtn');
    const verificationCodeDiv = document.getElementById('verificationCodeDiv');
    const codeDisplay = document.getElementById('codeDisplay');

    // Set initial state - email enabled, phone disabled
    const emailInput = document.getElementById('email');
    const passwordInput = document.getElementById('password');
    const phoneInput = document.getElementById('phone');
    const verificationInput = document.getElementById('verification_code');
    
    emailInput.disabled = false;
    passwordInput.disabled = false;
    phoneInput.disabled = true;
    verificationInput.disabled = true;
    
    // Set name attributes for enabled fields only
    emailInput.setAttribute('name', 'email');
    passwordInput.setAttribute('name', 'password');
    phoneInput.removeAttribute('name');
    verificationInput.removeAttribute('name');

    // Tab switching
    emailTabRadio.addEventListener('change', function() {
        if (this.checked) {
            emailForm.style.display = 'block';
            phoneForm.style.display = 'none';
            loginMethod.value = 'email';
            
            // Reset and disable phone form fields
            verificationCodeDiv.style.display = 'none';
            const phoneInput = document.getElementById('phone');
            const verificationInput = document.getElementById('verification_code');
            phoneInput.value = '';
            verificationInput.value = '';
            phoneInput.disabled = true;
            verificationInput.disabled = true;
            phoneInput.removeAttribute('name');
            verificationInput.removeAttribute('name');
            
            // Enable email fields
            const emailInput = document.getElementById('email');
            const passwordInput = document.getElementById('password');
            emailInput.disabled = false;
            passwordInput.disabled = false;
            emailInput.setAttribute('name', 'email');
            passwordInput.setAttribute('name', 'password');
        }
    });

    phoneTabRadio.addEventListener('change', function() {
        if (this.checked) {
            phoneForm.style.display = 'block';
            emailForm.style.display = 'none';
            loginMethod.value = 'phone';
            
            // Reset and disable email form fields
            const emailInput = document.getElementById('email');
            const passwordInput = document.getElementById('password');
            emailInput.value = '';
            passwordInput.value = '';
            emailInput.disabled = true;
            passwordInput.disabled = true;
            emailInput.removeAttribute('name');
            passwordInput.removeAttribute('name');
            
            // Enable phone fields
            const phoneInput = document.getElementById('phone');
            const verificationInput = document.getElementById('verification_code');
            phoneInput.disabled = false;
            verificationInput.disabled = false;
            phoneInput.setAttribute('name', 'phone');
            verificationInput.setAttribute('name', 'verification_code');
        }
    });

    // Send verification code
    sendCodeBtn.addEventListener('click', function() {
        const phone = document.getElementById('phone').value;
        if (!phone.trim()) {
            alert('<?php echo e(__("يرجى إدخال رقم الهاتف")); ?>');
            return;
        }

        sendCodeBtn.textContent = '<?php echo e(__("جاري الإرسال...")); ?>';
        sendCodeBtn.disabled = true;

        fetch('<?php echo e(route("patient.send.verification.code")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ phone: phone })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                verificationCodeDiv.style.display = 'block';
                if (data.code) { // Demo mode - remove in production
                    codeDisplay.textContent = '<?php echo e(__("رمز التحقق (للتجربة):")); ?> ' + data.code;
                }
                sendCodeBtn.innerHTML = '<i class="fas fa-check me-1"></i><?php echo e(__("تم الإرسال")); ?>';
                sendCodeBtn.classList.remove('btn-patient-secondary');
                sendCodeBtn.classList.add('btn-success');
            } else {
                alert(data.message || '<?php echo e(__("حدث خطأ، يرجى المحاولة مرة أخرى")); ?>');
                sendCodeBtn.innerHTML = '<i class="fas fa-sms me-1"></i><?php echo e(__("إرسال رمز التحقق")); ?>';
                sendCodeBtn.disabled = false;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('<?php echo e(__("حدث خطأ، يرجى المحاولة مرة أخرى")); ?>');
            sendCodeBtn.innerHTML = '<i class="fas fa-sms me-1"></i><?php echo e(__("إرسال رمز التحقق")); ?>';
            sendCodeBtn.disabled = false;
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\zakti\Documents\waiting-room-app\resources\views/patient/auth/login.blade.php ENDPATH**/ ?>