

<?php $__env->startSection('title', __('العيادات المفضلة')); ?>

<?php $__env->startSection('content'); ?>
<div class="min-vh-100 bg-light">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="container py-4">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <a href="<?php echo e(route('patient.dashboard')); ?>" class="text-muted me-3 text-decoration-none">
                        <svg width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                    </a>
                    <div>
                        <h1 class="fs-3 fw-bold text-dark mb-1"><?php echo e(__('العيادات المفضلة')); ?></h1>
                        <p class="small text-muted mb-0"><?php echo e(__('العيادات التي أضفتها لقائمة المفضلة')); ?></p>
                    </div>
                </div>
                <a href="<?php echo e(route('patient.search')); ?>" class="btn btn-primary d-flex align-items-center">
                    <svg class="me-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    <?php echo e(__('ابحث عن عيادات')); ?>

                </a>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <!-- Favorites Count -->
        <div class="row g-4 mb-4">
            <div class="col-lg-3">
                <div class="card">
                    <div class="card-body text-center">
                        <h3 class="fs-2 fw-bold text-danger mb-1" id="favoritesCount"><?php echo e($favorites->total() ?? 0); ?></h3>
                        <p class="small text-muted mb-0"><?php echo e(__('مكان مفضل')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-9">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title fs-6 fw-semibold mb-3"><?php echo e(__('نصائح حول المفضلة')); ?></h5>
                        <ul class="list-unstyled mb-0">
                            <li class="d-flex align-items-center mb-2">
                                <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                                <?php echo e(__('وصول سريع للعيادات التي تزورها بانتظام')); ?>

                            </li>
                            <li class="d-flex align-items-center mb-2">
                                <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                                <?php echo e(__('تتبع حالة الطوابير للعيادات المفضلة')); ?>

                            </li>
                            <li class="d-flex align-items-center mb-0">
                                <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                                <?php echo e(__('إشعارات خاصة من العيادات المفضلة')); ?>

                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Favorites List -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h3 class="fs-5 fw-semibold mb-0"><?php echo e(__('قائمة المفضلة')); ?></h3>
                <div class="d-flex gap-2">
                    <select class="form-select form-select-sm" id="sortBy" style="width: auto;">
                        <option value="name"><?php echo e(__('الترتيب بالاسم')); ?></option>
                        <option value="added"><?php echo e(__('تاريخ الإضافة')); ?></option>
                        <option value="visits"><?php echo e(__('عدد الزيارات')); ?></option>
                    </select>
                </div>
            </div>
            <div class="card-body">
                <div id="favoritesList">
                    <?php if($favorites->count() > 0): ?>
                        <?php $__currentLoopData = $favorites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $favorite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card mb-3">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                                                <svg class="text-primary" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                                </svg>
                                            </div>
                                        </div>
                                        <div>
                                            <h5 class="fs-6 fw-semibold mb-1"><?php echo e($favorite->name); ?></h5>
                                            <p class="text-muted small mb-0">
                                                <svg class="me-1" width="12" height="12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                </svg>
                                                <?php echo e($favorite->address ?: __('العنوان غير محدد')); ?>

                                            </p>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <button class="btn btn-sm btn-outline-danger" onclick="removeFavorite('<?php echo e($favorite->uuid); ?>')">
                                            <svg width="14" height="14" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </button>
                                        <a href="<?php echo e(route('patient.clinic.show', $favorite->uuid)); ?>" class="btn btn-sm btn-primary">
                                            <?php echo e(__('زيارة')); ?>

                                        </a>
                                    </div>
                                </div>
                                
                                <div class="row g-3">
                                    <?php if($favorite->phone): ?>
                                    <div class="col-md-3">
                                        <small class="text-muted"><?php echo e(__('الهاتف')); ?></small>
                                        <p class="mb-0 small"><?php echo e($favorite->phone); ?></p>
                                    </div>
                                    <?php endif; ?>
                                    <?php if($favorite->email): ?>
                                    <div class="col-md-3">
                                        <small class="text-muted"><?php echo e(__('البريد الإلكتروني')); ?></small>
                                        <p class="mb-0 small"><?php echo e($favorite->email); ?></p>
                                    </div>
                                    <?php endif; ?>
                                    <div class="col-md-3">
                                        <small class="text-muted"><?php echo e(__('عدد الخدمات')); ?></small>
                                        <p class="mb-0 small"><?php echo e($favorite->visitTypes->count()); ?> <?php echo e(__('خدمة')); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <small class="text-muted"><?php echo e(__('حالة الطابور')); ?></small>
                                        <span class="badge bg-success small"><?php echo e(__('متاح')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <!-- Pagination -->
                        <?php if($favorites->hasPages()): ?>
                        <div class="mt-4">
                            <?php echo e($favorites->links()); ?>

                        </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <!-- Empty state -->
                        <div class="text-center py-5">
                            <svg class="text-muted mb-3" width="64" height="64" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                            </svg>
                            <h3 class="fs-5 fw-semibold text-muted mb-2"><?php echo e(__('لا توجد أماكن مفضلة بعد')); ?></h3>
                            <p class="text-muted mb-4"><?php echo e(__('أضف الأماكن التي تزورها بانتظام لقائمة المفضلة للوصول السريع')); ?></p>
                            <a href="<?php echo e(route('patient.search')); ?>" class="btn btn-primary">
                                <svg class="me-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                                <?php echo e(__('ابحث عن أماكن')); ?>

                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Sample Favorite Entry (hidden by default, for demo purposes) -->
        <div class="d-none" id="sampleFavorite">
            <div class="card mb-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                                <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                                    <svg class="text-primary" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                    </svg>
                                </div>
                            </div>
                            <div>
                                <h5 class="fs-6 fw-semibold mb-1"><?php echo e(__('مركز الأسنان المتطور')); ?></h5>
                                <p class="text-muted small mb-1"><?php echo e(__('د. أحمد محمد - أخصائي أسنان')); ?></p>
                                <p class="text-muted small mb-0">
                                    <svg class="me-1" width="12" height="12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    <?php echo e(__('الرياض - حي النخيل')); ?>

                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <button class="btn btn-sm btn-outline-danger" onclick="removeFavorite('sample')">
                                <svg width="14" height="14" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <a href="#" class="btn btn-sm btn-primary">
                                <?php echo e(__('زيارة')); ?>

                            </a>
                        </div>
                    </div>
                    
                    <div class="row g-3">
                        <div class="col-md-4">
                            <small class="text-muted"><?php echo e(__('آخر زيارة')); ?></small>
                            <p class="mb-0 small"><?php echo e(__('15 مارس 2024')); ?></p>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted"><?php echo e(__('عدد الزيارات')); ?></small>
                            <p class="mb-0 small"><?php echo e(__('5 زيارات')); ?></p>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted"><?php echo e(__('حالة الطابور')); ?></small>
                            <span class="badge bg-success small"><?php echo e(__('متاح')); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function removeFavorite(clinicId) {
    if (confirm('<?php echo e(__("هل أنت متأكد من إزالة هذه العيادة من المفضلة؟")); ?>')) {
        // In real implementation, this would make an AJAX call to remove the favorite
        // For demo purposes, we'll just show a success message
        alert('<?php echo e(__("تم إزالة العيادة من قائمة المفضلة")); ?>');
        
        // Refresh the favorites list
        loadFavorites();
    }
}

function loadFavorites() {
    document.getElementById('favoritesList').innerHTML = `
        <div class="text-center py-3">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden"><?php echo e(__('جاري التحميل...')); ?></span>
            </div>
        </div>
    `;
    
    // Simulate loading
    setTimeout(() => {
        document.getElementById('favoritesList').innerHTML = `
            <div class="text-center py-5">
                <svg class="text-muted mb-3" width="64" height="64" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                </svg>
                <h3 class="fs-5 fw-semibold text-muted mb-2"><?php echo e(__('لا توجد عيادات مفضلة بعد')); ?></h3>
                <p class="text-muted mb-4"><?php echo e(__('أضف العيادات التي تزورها بانتظام لقائمة المفضلة للوصول السريع')); ?></p>
                <a href="<?php echo e(route('patient.search')); ?>" class="btn btn-primary">
                    <svg class="me-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    <?php echo e(__('ابحث عن عيادات')); ?>

                </a>
            </div>
        `;
        document.getElementById('favoritesCount').textContent = '0';
    }, 1000);
}

// Sort functionality
document.getElementById('sortBy').addEventListener('change', function() {
    loadFavorites(); // Reload with new sort order
});

// Load favorites on page load
document.addEventListener('DOMContentLoaded', function() {
    // Initial load is handled by the HTML content
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.patient', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\zakti\Documents\waiting-room-app\resources\views/patient/favorites.blade.php ENDPATH**/ ?>